<?php
/**
 * File: google-fonts.php
 *
 * @package Login Customizer
 */

defined( 'ABSPATH' ) || exit;

$wp_customize->add_setting(
	'login_customizer_dummy[google_fonts]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer_dummy[google_fonts]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => __( 'Google Fonts', 'login-customizer' ),
			'description' => esc_attr__( 'Do more customization on your login pages with 700+ beautiful Google fonts that can match any style.', 'login-customizer' ),
			'section'     => 'login_customizer__section--google-fonts',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_dummy[google_fonts_image]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Dummy_Control(
		$wp_customize,
		'login_customizer_dummy[google_fonts_image]',
		array(
			'type'        => 'login-customizer-dummy-control',
			'label'       => __( 'Google Fonts', 'login-customizer' ),
			'description' => esc_attr__( 'some description', 'login-customizer' ),
			'section'     => 'login_customizer__section--google-fonts',
			'image_src'   => esc_url( LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/images/google-fonts.jpg' ),
		)
	)
);
