<?php
/**
 * Remember Me Customizer Section.
 *
 * @package Login Customizer
 */

$wp_customize->add_setting(
	'login_customizer[remember_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer[remember_title]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => esc_html__( 'Remember', 'login-customizer' ),
			'description' => esc_html__( 'Easily customize the Remember Me element on the login form.', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[remember_font]',
	array(
		'default'           => $defaults['remember_font'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'wp_filter_nohtml_kses',
	)
);

$wp_customize->add_control(
	'login_customizer[remember_font]',
	array(
		'type'    => 'select',
		'label'   => esc_html__( 'Font', 'login-customizer' ),
		'section' => 'login_customizer__section--styles',
		'choices' => $this->get_fonts(),
	)
);

$wp_customize->add_setting(
	'login_customizer[remember_font_size]',
	array(
		'default'           => $defaults['remember_font_size'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[remember_font_size]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Size', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['remember_font_size'],
			'input_attrs' => array(
				'min'  => 8,
				'max'  => 20,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[remember_position]',
	array(
		'default'           => $defaults['remember_position'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[remember_position]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Position', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['remember_position'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 20,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[remember_color]',
	array(
		'default'           => $defaults['remember_color'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'login_customizer[remember_color]',
		array(
			'label'   => esc_html__( 'Color', 'login-customizer' ),
			'section' => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[remember_hide]',
	array(
		'default'           => false,
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => array( $this, 'sanitize_checkbox' ),
	)
);

$wp_customize->add_control(
	new Login_Customizer_Toggle_Control(
		$wp_customize,
		'login_customizer[remember_hide]',
		array(
			'label'   => esc_html__( 'Hide Remember Me', 'login-customizer' ),
			'type'    => 'login-customizer-toggle',
			'section' => 'login_customizer__section--styles',
		)
	)
);
