<?php
/**
 * Admin notices.
 *
 * @package Login Customizer
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Login_Customizer_Notices' ) ) :
	/**
	 * Login_Customizer_Notices Class
	 */
	class Login_Customizer_Notices {

		/**
		 * Constructor
		 */
		public function __construct() {

			// Retrieve the Login Customizer page.
			$page = Login_Customizer()->get_login_customizer_page();

			// Add a warning notice if the user has attempted to trash the Login Customizer page.
			if ( isset( $_GET['ids'] ) && intval( $_GET['ids'] ) === $page->ID ) { // phpcs:ignore  WordPress.Security.NonceVerification
				add_action( 'admin_notices', array( $this, 'double_install_admin_notice' ) );
			}
		}

		/**
		 * @return void
		 */
		private static function render_admin_notice( $message, $type = 'update', $dismissable = false ) {
			if ( ! is_admin() ) {
				return;
			} elseif ( ! is_user_logged_in() ) {
				return;
			} elseif ( ! current_user_can( 'update_core' ) ) {
				return;
			}

			$dismissable = ( false === $dismissable ) ? null : ' is-dismissible';

			$allowed_html_array = array(
				'a' => array(
					'href' => array(),
				),
				'b' => array(),
			);

			echo '<div class="notice ' . esc_attr( $type . $dismissable ) . '">';
				echo '<p>' . wp_kses( $message, $allowed_html_array ) . '</p>';
				echo '<style>.updated.notice.is-dismissible {display: none;}</style>';
			echo '</div>';
		}

		/**
		 *
		 * @return void
		 */
		public function double_install_admin_notice() {
			/* translators: 1: Name of the plugin */
			$message = __( '<b>The %s page may not be removed.</b> This page is used for login page styling within the Customizer.', 'login-customizer' );

			$this->render_admin_notice( sprintf( $message, 'Login Customizer' ), 'notice-warning', false );
		}
	}

endif;

return new Login_Customizer_Notices();
