<?php
/**
 * File: class-login-customizer-dummy-control.php
 *
 * @package Login Customizer
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return;
}

if ( ! class_exists( 'Login_Customizer_Dummy_Control' ) ) {
	/**
	 * Class Login_Customizer_Dummy_Control
	 */
	class Login_Customizer_Dummy_Control extends WP_Customize_Control {
		/**
		 * Login Customizer dummy control.
		 *
		 * @var string
		 */
		public $type = 'login-customizer-dummy-control';

		/**
		 * Login Customizer image src
		 *
		 * @var string
		 */
		public $image_src;

		/**
		 * Converting custom attributes to json
		 */
		public function to_json() {
			parent::to_json();

			$this->json['image_src'] = $this->image_src;
		}

		/**
		 * Render Content
		 */
		public function render_content() {}

		/**
		 * Content Template
		 *
		 * @throws Freemius_Exception Exception.
		 */
		protected function content_template() {
			$purchase_url = 'https://hajkeroo.cz/pricing/?utm_source=plugin&utm_medium=customizer';
			?>
			<a draggable="false" href="<?php echo esc_url( $purchase_url ); ?>" style="font-size: 17px;" target="_blank">
				<?php esc_attr_e( 'Upgrade To Pro', 'login-customizer' ); ?>
				<i style="vertical-align: baseline;width: auto;height: auto;" class="dashicons dashicons-external"></i>
				<img style="margin-top: 10px" draggable="false" src="{{ data.image_src }}" alt="#">
			</a>
			<?php
		}
	}
}
