<?php
/**
 * Login Customizer File Import Button Control
 *
 * @package Login Customizer
 */

/**
 * Class Login_Customizer_File_Import_Button_Control
 */
class Login_Customizer_File_Import_Button_Control extends WP_Customize_Control {
	/**
	 * Control type.
	 *
	 * @since 4.2.0
	 * @var string
	 */
	public $type = 'import-json-file';

	/**
	 * Enqueue control related scripts/styles.
	 *
	 * @since 3.4.0
	 * @since 4.2.0 Moved from WP_Customize_Upload_Control.
	 */
	public function enqueue() {
		if ( ! defined( 'LOGIN_CUSTOMIZER_DEBUG' ) || ( defined( 'LOGIN_CUSTOMIZER_DEBUG' ) && false === LOGIN_CUSTOMIZER_DEBUG ) ) {
			return;
		}

		// Define where the asset is loaded from.
		$dir = Login_Customizer()->asset_source( 'js', 'controls/' );

		// Enqueue the asset. Note that there is no minified version of this singular asset.
		wp_enqueue_script( 'login-customizer-file-import-control', $dir . 'login-customizer-file-import-control.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
		wp_localize_script(
			'login-customizer-file-import-control',
			'login_customizer_file_import_object',
			array(
				'nonce'   => wp_create_nonce(),
				'element' => $this->type,
			)
		);
	}

	/**
	 * Function use to grt values
	 */
	public function to_json() {
		parent::to_json();

		$this->json['id']           = $this->id;
		$this->json['value']        = $this->value();
		$this->json['link']         = $this->get_link();
		$this->json['defaultValue'] = $this->setting->default;
	}

	/**
	 * Don't render any content for this control from PHP.
	 */
	public function render_content() {
		?>
		<div class="login-customizer-import-export-btns">
			<button class="button-secondary login-customizer-import-export-buttons" id="login-customizer-export-btn" data-login-customizer-export-element="#login-customizer-export-container"><?php esc_attr_e( 'Export', 'login-customizer' ); ?></button>
			<button class="button-secondary login-customizer-import-export-buttons" id="login-customizer-import-btn" data-login-customizer-import-element="#login-customizer-import-container"><?php esc_attr_e( 'Import', 'login-customizer' ); ?></button>
		</div>


		<div id="login-customizer-export-container" class="login-customizer-ix-container" style="display: none;">
			<textarea class="login-customizer-textarea" id="login-customizer-export-textarea"></textarea>
			<button class="button-secondary login-customizer-export-button" data-login-customizer-copy-element="#login-customizer-export-textarea" id="login-customizer-export-btn"><?php esc_attr_e( 'Copy to Clipboard', 'login-customizer' ); ?></button>
		</div>

		<div id="login-customizer-import-container" class="login-customizer-ix-container" style="display: none;">
			<textarea class="login-customizer-textarea" id="login-customizer-import-textarea"></textarea>
			<button class="button-secondary login-customizer-import-button" id="login-customizer-import-btn" data-login-customizer-import-json-element="#login-customizer-import-textarea"><?php esc_attr_e( 'Save and Apply', 'login-customizer' ); ?></button>
		</div>

		<div style="display: none;" class="login-customizer-snackbar login-customizer-snackbar-hide-2000">
			<span class="login-customizer-snackbar-text">
				<?php esc_attr_e( 'Text copied to clipboard', 'login-customizer' ); ?>
				<button class="login-customizer-snackbar-close"><?php esc_attr_e( 'Close', 'login-customizer' ); ?></button>
			</span>
		</div>
		<?php
	}
}
