<?php
/**
 * Layout Customizer Control
 *
 * @see https://developer.wordpress.org/reference/classes/wp_customize_control/
 *
 * @package Login Customizer
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Exit if WP_Customize_Control does not exsist.
if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return null;
}

/**
 * This class is for the gallery selector in the Customizer.
 *
 * @access  public
 */
class Login_Customizer_Gallery_Control extends WP_Customize_Control {

	/**
	 * The control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'login-customizer-gallery';

	/**
	 * Enqueue neccessary custom control scripts.
	 */
	public function enqueue() {

		// If it is not active, we're loading the concated and minified login-customizer-custom-controls.min.js file.
		if ( ! defined( 'LOGIN_CUSTOMIZER_DEBUG' ) || ( defined( 'LOGIN_CUSTOMIZER_DEBUG' ) && false === LOGIN_CUSTOMIZER_DEBUG ) ) {
			return;
		}

		// Define where the asset is loaded from.
		$dir = Login_Customizer()->asset_source( 'js', 'controls/' );

		// Enqueue the asset. Note that there is no minified version of this singular asset.
		wp_enqueue_script( 'login-customizer-gallery-control', $dir . 'login-customizer-gallery-control.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
	}

	/**
	 * Add custom parameters to pass to the JS via JSON.
	 *
	 * @return void
	 */
	public function to_json() {
		parent::to_json();

		// The setting value.
		$this->json['id']      = $this->id;
		$this->json['value']   = $this->value();
		$this->json['link']    = $this->get_link();
		$this->json['choices'] = $this->choices;
	}

	/**
	 * Don't render the content via PHP.  This control is handled with a JS template.
	 *
	 * @return void
	 */
	public function render_content() {}

	/**
	 * @return void
	 */
	protected function content_template() {
		?>

		<# if ( ! data.choices ) {
			return;
		} #>

		<# if ( data.label ) { #>
			<span class="customize-control-title">{{ data.label }}</span>
		<# } #>

		<# if ( data.description ) { #>
			<span class="description customize-control-description">{{ data.description }}</span>
		<# } #>

		<div id="login-customizer-gallery" class="login-customizer-gallery">

			<# for ( choice in data.choices ) { #>

				<div class="login-customizer-gallery__item">

					<input type="radio" value="{{ choice }}" name="_customize-{{ data.id }}" id="{{ data.id }}{{ choice }}" class="login-customizer-gallery__checkbox" {{{ data.link }}} <# if ( ! data.value ) { #> checked="checked" <# } #> />

					<label for="{{ data.id }}{{ choice }}">
						<div class="login-customizer-gallery__intrinsic">
							<div class="login-customizer-gallery__img" style="background-image: url( {{ data.choices[ choice ] }} );"></div>
						</div>
					</label>

				</div>

			<# } #>

		</div>

		<?php
	}
}
