<?php
/**
 * Title Customizer Control
 *
 * @package Login Customizer
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Exit if WP_Customize_Control does not exsist.
if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return null;
}

/**
 * This class is for the title control in the Customizer.
 *
 * @access  public
 */
class Login_Customizer_License_Control extends WP_Customize_Control {

	/**
	 * Set the control type.
	 *
	 * @var $type Customizer type
	 */
	public $type = 'login-customizer-license';

	public function enqueue() {

		if ( ! defined( 'LOGIN_CUSTOMIZER_DEBUG' ) || ( defined( 'LOGIN_CUSTOMIZER_DEBUG' ) && false === LOGIN_CUSTOMIZER_DEBUG ) ) {
			return;
		}

		// Define where the asset is loaded from.
		$dir = Login_Customizer()->asset_source( 'js', 'controls/' );

		// Enqueue the asset. Note that there is no minified version of this singular asset.
		wp_enqueue_script( 'login-customizer-license-control', $dir . 'login-customizer-license-control.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
	}

	/**
	 * Render the content.
	 */
	public function render_content() {
		$customizer       = new Login_Customizer_License_Handler();
		$key              = $customizer->key();
		$status           = $customizer->status();
		$expiration       = $customizer->expiration();
		$site_count       = $customizer->site_count();
		$activations_left = $customizer->activations_left();
		$is_valid         = $customizer->is_valid_license();
		$visibility       = ( true === $is_valid ) ? 'is-valid' : 'is-not-valid';

		// Array of allowed HTML.
		$allowed_html_array = array(
			'a' => array(
				'href'   => array(),
				'target' => array(),
			),
		);

		if ( isset( $this->label ) ) {
			echo '<span class="customize-control-title">' . esc_html( $this->label ) . '</span>';
		}

		if ( ! empty( $this->description ) ) {
			echo '<span class="customize-control-description">' . wp_kses( $this->description, $allowed_html_array ) . '</span>';
		}
		?>

		<form id="license-form" name="license-form">
			<input id="license-key" class="license" name="license-key" spellcheck="false" type="text" <?php $this->input_attrs(); ?> value="<?php echo esc_attr( $this->value() ); ?>" <?php $this->link(); ?> />
			<input type="submit" name="login-customizer-license" id="login-customizer-activate-license" value="Activate" class="button-secondary button <?php echo esc_attr( $visibility ); ?>">
			<input type="submit" name="login-customizer-deactivate-license" id="login-customizer-deactivate-license" value="Deactivate" class="button-secondary button <?php echo esc_attr( $visibility ); ?>">
			<div class="spinner"></div>
		</form>

		<div id="license-error"></div>

		<ul id="license-info" class="<?php echo esc_attr( $visibility ); ?>">

			<li><strong>Status:</strong> <span id="license-status"><?php echo esc_html( $status ); ?></span></li>

			<li id="li--license-expiration"><strong>Expiration:</strong> <span id="license-expiration"><?php echo esc_html( $expiration ); ?></span></li>

			<li id="li--license-site_count"><strong>Activations:</strong>
				<?php if ( 'unlimited' !== $activations_left ) { ?>
					<span id="license-site_count"><?php echo esc_html( $site_count ); ?></span> out of <span id="license-activations_left"><?php echo esc_html( $activations_left ); ?></span></li>
				<?php } else { ?>
					Unlimited
				<?php } ?>
			</li>

		<ul>

		<?php
	}
}
