<?php
/**
 * Template Customizer Control
 *
 * @package Login Customizer
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Exit if WP_Customize_Control does not exsist.
if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return null;
}

/**
 * This class is for the gallery selector in the Customizer.
 *
 * @access  public
 */
class Login_Customizer_Template_Control extends WP_Customize_Control {

	/**
	 * The control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'login-customizer-templates';

	/**
	 * Enqueue neccessary custom control scripts.
	 */
	public function enqueue() {

		if ( ! defined( 'LOGIN_CUSTOMIZER_DEBUG' ) || ( defined( 'LOGIN_CUSTOMIZER_DEBUG' ) && false === LOGIN_CUSTOMIZER_DEBUG ) ) {
			return;
		}

		// Define where the asset is loaded from.
		$dir = Login_Customizer()->asset_source( 'js', 'controls/' );

		// Enqueue the asset. Note that there is no minified version of this singular asset.
		wp_enqueue_script( 'login-customizer-template-control', $dir . 'login-customizer-template-control.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
	}

	/**
	 * @return void
	 */
	public function to_json() {
		parent::to_json();

		// The setting value.
		$this->json['id']      = $this->id;
		$this->json['value']   = $this->value();
		$this->json['link']    = $this->get_link();
		$this->json['choices'] = $this->choices;
	}

	/**
	 * @return void
	 */
	public function render_content() {}

	/**
	 * @return void
	 */
	protected function content_template() {
		?>

		<# if ( ! data.choices ) {
			return;
		} #>

		<# if ( data.description ) { #>
			<span class="customize-control-description">{{ data.description }}</span>
		<# } #>

		<div id="login-customizer-templates" class="login-customizer-templates">

			<# for ( choice in data.choices ) { #>

				<input type="radio" value="{{ choice }}" name="_customize-{{ data.id }}" id="{{ data.id }}{{ choice }}" class="login-customizer-templates__input" {{{ data.link }}} <# if ( data.value === choice ) { #> checked="checked" <# } #> />

				<label for="{{ data.id }}{{ choice }}" class="login-customizer-templates__label">
					<div class="login-customizer-templates__intrinsic">
						<div class="login-customizer-templates__screenshot" style="background-image: url( {{ data.choices[ choice ] }} );"></div>
					</div>
				</label>

			<# } #>

		</div>

		<?php
	}
}
