<?php
/**
 * Toggle Customizer Control
 *
 * @see https://developer.wordpress.org/reference/classes/wp_customize_control/
 *
 * @package Login Customizer
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Exit if WP_Customize_Control does not exsist.
if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return null;
}

/**
 * This class is for the toggle control in the Customizer.
 *
 * @access public
 */
class Login_Customizer_Toggle_Control extends WP_Customize_Control {

	/**
	 * The type of customize control.
	 * @var    string
	 */
	public $type = 'login-customizer-toggle';

	/**
	 * Enqueue neccessary custom control scripts.
	 */
	public function enqueue() {

		if ( ! defined( 'LOGIN_CUSTOMIZER_DEBUG' ) || ( defined( 'LOGIN_CUSTOMIZER_DEBUG' ) && false === LOGIN_CUSTOMIZER_DEBUG ) ) {
			return;
		}

		// Define where the asset is loaded from.
		$dir = Login_Customizer()->asset_source( 'js', 'controls/' );

		// Enqueue the asset. Note that there is no minified version of this singular asset.
		wp_enqueue_script( 'login-customizer-toggle-control', $dir . 'login-customizer-toggle-control.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
	}

	/**
	 * Add custom parameters to pass to the JS via JSON.
	 * @return void
	 */
	public function to_json() {
		parent::to_json();

		// The setting value.
		$this->json['id']           = $this->id;
		$this->json['value']        = $this->value();
		$this->json['link']         = $this->get_link();
		$this->json['defaultValue'] = $this->setting->default;
	}

	/**
	 * @return void
	 */
	public function render_content() {}

	/**
	 * @return void
	 */
	protected function content_template() {
		?>
		<label class="toggle">
			<div class="toggle--wrapper">

				<# if ( data.label ) { #>
					<span class="customize-control-title">{{ data.label }}</span>
				<# } #>

				<input id="toggle-{{ data.id }}" type="checkbox" class="toggle--input" value="{{ data.value }}" {{{ data.link }}} <# if ( data.value ) { #> checked="checked" <# } #> />
				<label for="toggle-{{ data.id }}" class="toggle--label"></label>
			</div>

			<# if ( data.description ) { #>
				<span class="description customize-control-description">{{ data.description }}</span>
			<# } #>
		</label>
		<?php
	}
}
