<?php
/**
 * Button Customizer Section.
 *
 * @package Login Customizer
 */

$wp_customize->add_setting(
	'login_customizer[button_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer[button_title]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => esc_html__( 'Button', 'login-customizer' ),
			'description' => esc_html__( 'Customize the full display appearance of the login submit button.', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_bg]',
	array(
		'default'           => $defaults['button_bg'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'login_customizer[button_bg]',
		array(
			'label'   => esc_html__( 'Background', 'login-customizer' ),
			'section' => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_border]',
	array(
		'default'           => $defaults['button_border'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[button_border]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Border', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['button_border'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 10,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_border_color]',
	array(
		'default'           => $defaults['button_border_color'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'login_customizer[button_border_color]',
		array(
			'label'   => esc_html__( 'Border Color', 'login-customizer' ),
			'section' => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_side_padding]',
	array(
		'default'           => $defaults['button_side_padding'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[button_side_padding]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Padding', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['button_side_padding'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 60,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_padding_top]',
	array(
		'default'           => $defaults['button_padding_top'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[button_padding_top]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Padding Top', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['button_padding_top'],
			'input_attrs' => array(
				'min'  => 1,
				'max'  => 20,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_padding_bottom]',
	array(
		'default'           => $defaults['button_padding_bottom'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[button_padding_bottom]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Padding Bottom', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['button_padding_bottom'],
			'input_attrs' => array(
				'min'  => 1,
				'max'  => 20,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_radius]',
	array(
		'default'           => $defaults['button_radius'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[button_radius]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Radius', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['button_radius'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 60,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_shadow]',
	array(
		'default'           => $defaults['button_shadow'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[button_shadow]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Shadow', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['button_shadow'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 30,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_shadow_opacity]',
	array(
		'default'           => $defaults['button_shadow_opacity'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[button_shadow_opacity]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Shadow Opacity', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => '%',
			'default'     => $defaults['button_shadow_opacity'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 100,
				'step' => 1,
			),
		)
	)
);


/**
 * Button Text.
 */
$wp_customize->add_setting(
	'login_customizer[button_text_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer[button_text_title]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => esc_html__( 'Text', 'login-customizer' ),
			'description' => esc_html__( 'Change the button font, color and size.', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_font]',
	array(
		'default'           => $defaults['button_font'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'wp_filter_nohtml_kses',
	)
);

$wp_customize->add_control(
	'login_customizer[button_font]',
	array(
		'type'    => 'select',
		'label'   => esc_html__( 'Font', 'login-customizer' ),
		'section' => 'login_customizer__section--styles',
		'choices' => $this->get_fonts(),
	)
);

$wp_customize->add_setting(
	'login_customizer[button_font_size]',
	array(
		'default'           => $defaults['button_font_size'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[button_font_size]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Size', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['button_font_size'],
			'input_attrs' => array(
				'min'  => 13,
				'max'  => 40,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[button_color]',
	array(
		'default'           => $defaults['button_color'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'login_customizer[button_color]',
		array(
			'label'   => esc_html__( 'Color', 'login-customizer' ),
			'section' => 'login_customizer__section--styles',
		)
	)
);
