<?php
/**
 * Language Switcher Customizer Settings
 *
 * @package Login Customizer
 */

defined( 'ABSPATH' ) || exit;

$wp_customize->add_setting(
	'login_customizer_translations[translation_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer_translations[translation_title]',
		array(
			'type'    => 'login-customizer-title',
			'label'   => esc_html__( 'Language Switcher', 'login-customizer' ),
			'section' => 'login_customizer__section--translations',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_translations[translation]',
	array(
		'default'           => 0,
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => array( $this, 'sanitize_checkbox' ),
	)
);

$wp_customize->add_control(
	new Login_Customizer_Toggle_Control(
		$wp_customize,
		'login_customizer_translations[translation]',
		array(
			'label'    => esc_html__( 'Enable', 'login-customizer' ),
			'type'     => 'login-customizer-toggle',
			'settings' => 'login_customizer_translations[translation]',
			'section'  => 'login_customizer__section--translations',
		)
	)
);
