<?php
/**
 * File: background-slider.php
 *
 * @package Login Customizer
 */

defined( 'ABSPATH' ) || exit;

$wp_customize->add_setting(
	'login_customizer_dummy[background_slider]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer_dummy[background_slider]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => __( 'Background Slider', 'login-customizer' ),
			'description' => esc_attr__( 'Add more interaction with the image slider in the background and get complete control over effects and transition speed.', 'login-customizer' ),
			'section'     => 'login_customizer__section--background-slider',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_dummy[background_slider_image]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Dummy_Control(
		$wp_customize,
		'login_customizer_dummy[background_slider_image]',
		array(
			'type'        => 'login-customizer-dummy-control',
			'label'       => __( 'Background Slider', 'login-customizer' ),
			'description' => esc_attr__( 'some description', 'login-customizer' ),
			'section'     => 'login_customizer__section--background-slider',
			'image_src'   => esc_url( LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/images/background-slider.gif' ),
		)
	)
);
