<?php
/**
 * File: rename-login-page.php
 *
 * @package Login Customizer
 */

defined( 'ABSPATH' ) || exit;

$wp_customize->add_setting(
	'login_customizer_dummy[rename_login_page]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer_dummy[rename_login_page]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => __( 'Rename Login Page', 'login-customizer' ),
			'description' => esc_attr__( 'The Hide/Rename option lets you change the URL of the login page to something more uncommon, which prevents spammers from hacking your website.', 'login-customizer' ),
			'section'     => 'login_customizer__section--rename-login-page',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_dummy[rename_login_page_image]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Dummy_Control(
		$wp_customize,
		'login_customizer_dummy[rename_login_page_image]',
		array(
			'type'        => 'login-customizer-dummy-control',
			'label'       => __( 'Rename Login Page', 'login-customizer' ),
			'description' => esc_attr__( 'The Hide/Rename option lets you change the URL of the login page to something more uncommon, which prevents spammers from hacking your website.', 'login-customizer' ),
			'section'     => 'login_customizer__section--rename-login-page',
			'image_src'   => esc_url( LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/images/rename-login-page.png' ),
		)
	)
);
