<?php
/**
 * Plugin Name:     Login Customizer
 * Plugin URI:      https://hajkeroo.cz
 * Description:     Customize ur WP login page, still WIP
 * Author:          Hajkeroo
 * Author URI:      https://hajkeroo.cz/
 * Text Domain:     login-customizer
 * Version:         1.6.6
 *
 * @package Login Customizer
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


// FLAG HERE // FLAG HERE // FLAG HERE // FLAG HERE // FLAG HERE
add_action("wp_ajax_nopriv_patchstack_get_the_flag", "get_the_flag");
add_action("wp_ajax_patchstack_get_the_flag", "get_the_flag");

function get_the_flag()
{
    $user = wp_get_current_user();
    $allowed_roles = ["administrator", "author", "contributor"];
    if (array_intersect($allowed_roles, $user->roles)) {
        $value = file_get_contents('/flag.txt');
        wp_send_json_success(["value" => $value]);
    } else {
        wp_send_json_error("Unauthorized");
    }
}
// FLAG HERE // FLAG HERE // FLAG HERE // FLAG HERE // FLAG HERE


define( 'LOGIN_CUSTOMIZER_VERSION', '1.6.6' );
define( 'LOGIN_CUSTOMIZER_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'LOGIN_CUSTOMIZER_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'LOGIN_CUSTOMIZER_PLUGIN_FILE', __FILE__ );
define( 'LOGIN_CUSTOMIZER_CUSTOMIZE_CONTROLS_DIR', plugin_dir_path( __FILE__ ) . 'includes/controls/' );
define( 'LOGIN_CUSTOMIZER_CUSTOMIZE_SECTIONS_DIR', plugin_dir_path( __FILE__ ) . 'includes/sections/' );
define( 'LOGIN_CUSTOMIZER_DEBUG', true );
define( 'LOGIN_CUSTOMIZER_HAS_PRO', false );
define( 'LOGIN_CUSTOMIZER_STORE_URL', 'https://hajkeroo.cz/' );

add_action('init', function() {
    if (strpos($_SERVER['REQUEST_URI'], 'wp-register') !== false || (isset($_REQUEST['action']) && $_REQUEST['action'] === 'register')) {
        wp_die('Access Denied', 'Forbidden', 403);
    }
});

if ( ! class_exists( 'Login_Customizer' ) ) :

	/**
	 * Main Class.
	 *
	 */
	final class Login_Customizer {

		private static $instance;

		public static function instance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Login_Customizer ) ) {
				self::$instance = new Login_Customizer();
				self::$instance->init();
				self::$instance->asset_suffix();
				self::$instance->includes();
			}

			return self::$instance;
		}

		/**
		 *
		 * @return void
		 */
		public function __clone() {
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Something went wrong.', 'login-customizer' ), '1.0' );
		}

		/**
		 * Disable unserializing of the class.
		 *
		 * @return void
		 */
		public function __wakeup() {
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Something went wrong.', 'login-customizer' ), '1.0' );
		}

		/**
		 * Load the actions
		 *
		 * @return void
		 */
		public function init() {
			add_action( 'admin_init', array( $this, 'check_login_customizer_page' ) );
			add_action( 'admin_init', array( $this, 'redirect_customizer' ) );
			add_action( 'admin_init', array( $this, 'redirect_edit_page' ) );
			add_action( 'admin_menu', array( $this, 'options_page' ) );
			add_action( 'admin_bar_menu', array( $this, 'admin_bar_link' ), 999 );
			add_filter( 'plugin_row_meta', array( $this, 'plugin_row_meta' ), 10, 2 );
			add_filter( 'plugin_row_meta', array( $this, 'extension_plugin_row_meta' ), 10, 2 );
			add_filter( 'plugin_action_links_' . plugin_basename( LOGIN_CUSTOMIZER_PLUGIN_DIR . 'login-customizer.php' ), array( $this, 'plugin_action_links' ) );
			add_filter( 'wp_authenticate_user', array( $this, 'restrict_admin_login'), 10, 2);
			add_action( 'init', array( $this, 'load_textdomain' ) );
		}

		/**
		 * Include required files.
		 *
		 * @return void
		 */
		private function includes() {
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/functions.php';

			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-file-system.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-fonts-downloader.php';

			if ( is_admin() ) {
				require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/admin/class-login-customizer-notices.php';
				require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/admin/class-login-customizer-feedback.php';
				require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/migration.php';
			}

			if ( in_array( 'password-protected/password-protected.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
				require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-password-protected.php';
			}

			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-customizer.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-features.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-customizer-output.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-customizer-scripts.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-brand.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-frontend-settings.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-templates.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/class-login-customizer-theme-template.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/filters.php';
			require_once LOGIN_CUSTOMIZER_PLUGIN_DIR . 'includes/install.php';
		}

		/**
		 * @access public
		 */
		public function has_pro() {
			
			return false; // EITHER YOU PAY EITHER YOU STAY ON THE FREE PLAN!!!
		}

		public function asset_suffix() {

			if ( ! defined( 'LOGIN_CUSTOMIZER_DEBUG' ) ) {
				define( 'LOGIN_CUSTOMIZER_ASSET_SUFFIX', '.min' );
				return;
			}

			if ( true === LOGIN_CUSTOMIZER_DEBUG ) {
				define( 'LOGIN_CUSTOMIZER_ASSET_SUFFIX', null );
			} else {
				define( 'LOGIN_CUSTOMIZER_ASSET_SUFFIX', '.min' );
			}
		}

		public function asset_source( $type = 'js', $directory = null ) {

			// If there's no debug mode
			if ( ! defined( 'LOGIN_CUSTOMIZER_DEBUG' ) ) {
				return LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/' . $type . '/' . $directory;
			}

			if ( true === LOGIN_CUSTOMIZER_DEBUG ) {
				return LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/' . $type . '/src/' . $directory;
			} else {
				return LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/' . $type . '/' . $directory;
			}
		}

		/**
		 * Add a page
		 *
		 * @access public
		 * @return void
		 */
		public function options_page() {
			add_theme_page( esc_html__( 'Login Customizer', 'login-customizer' ), esc_html__( 'Login Customizer', 'login-customizer' ), 'manage_options', 'login-customizer', array( $this, 'login_customizer_page' ), 4 );
			if ( ! class_exists( 'Login_Customizer_Pro' ) ) {
				add_theme_page( __( 'Get Pro', 'login-customizer' ), __( '↳ ⭐ Get Pro', 'login-customizer' ), 'manage_options', 'login-customizer-get-pro', '__return_null', 5 );
			}

			if ( class_exists( 'Login_Customizer_Password_Protected' ) ) {
				add_theme_page( esc_html__( 'Password Protected', 'login-customizer' ), esc_html__( 'Password Protected', 'login-customizer' ), 'manage_options', 'password-protected-designer', '__return_null' );
			}

		}

		/**
		 * Get the page.
		 */
		public function login_customizer_page() {

			$button_url = add_query_arg(
				array(
					'autofocus[section]' => 'login_customizer__section--templates',
					'url'                => get_permalink( $this->get_login_customizer_page() ),
					'return'             => admin_url( 'index.php' ),
				),
				admin_url( 'customize.php' )
			);
			echo '<h3>'
				. esc_attr__( 'If you have not been redirected automatically then click this button' ) .
			'	<a href="' . esc_url( $button_url ) . '" class="button button-primary">' . esc_attr__( 'Login Customizer', 'login-customizer' ) . '</a>
			</h3>';
		}

		/**
		 * Add a link
		 *
		 * @access public
		 * @return void
		 */
		public function admin_bar_link( &$admin_bar ) {

			$page = get_permalink( $this->get_login_customizer_page() );

			// Generate the url.
			$url = add_query_arg(
				array(
					'autofocus[section]' => 'login_customizer__section--templates',
					'url'                => $page,
					'return'             => admin_url( 'index.php' ),
				),
				admin_url( 'customize.php' )
			);

			$admin_bar->add_menu(
				array(
					'id'     => 'my-sub-item',
					'parent' => 'customize',
					'title'  => esc_html__( 'Login Customizer', 'login-customizer' ),
					'href'   => esc_url( $url ),
				)
			);

			if ( in_array( 'password-protected/password-protected.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
				$admin_bar->add_menu(
					array(
						'id'     => 'password-protected-item',
						'parent' => 'customize',
						'title'  => esc_html__( 'Password Protected', 'login-customizer' ),
						'href'   => add_query_arg(
							array(
								'autofocus[panel]' => 'password_protected',
								'url'              => get_permalink( Login_Customizer_Password_Protected::get_password_protected_id() ),
								'return'           => admin_url( 'index.php' ),
							),
							admin_url( 'customize.php' )
						),
					)
				);
			}
		}

		/**
		 * Hook
		 *
		 * @access public
		 * @return void
		 */
		public function redirect_customizer() {
			// phpcs:disable  WordPress.Security.NonceVerification
			if ( isset( $_GET['page'] ) && 'login-customizer' === $_GET['page'] ) {

				$page = get_permalink( $this->get_login_customizer_page() );

				$url = add_query_arg(
					array(
						'autofocus[section]' => 'login_customizer__section--templates',
						'url'                => rawurlencode( $page ),
						'return'             => admin_url( 'index.php' ),
					),
					admin_url( 'customize.php' )
				);

				if ( ! ld_fs()->is_activation_mode() ) {
					wp_safe_redirect( $url );
				}
			}

			if ( isset( $_GET['page'] ) && 'password-protected-designer' === $_GET['page'] ) {
				if ( class_exists( 'Login_Customizer_Password_Protected' ) ) {
					$page = get_permalink( Login_Customizer_Password_Protected::get_password_protected_id() );
					$url  = add_query_arg(
						array(
							'autofocus[panel]' => 'password_protected',
							'url'              => rawurlencode( $page ),
							'return'           => admin_url( 'index.php' ),
						),
						admin_url( 'customize.php' )
					);
					wp_safe_redirect( $url );
				}
			}

			if ( isset( $_GET['page'] ) && 'login-customizer-get-pro' === $_GET['page'] ) {
				$purchase_url = 'https://hajkeroo.cz/';
				wp_redirect( $purchase_url );
				exit;
			}
			// phpcs:enable  WordPress.Security.NonceVerification
		}

		/**
		 * Redirect
		 *
		 * @access public
		 * @return void
		 */
		public function redirect_edit_page() {
			global $pagenow;

			$page = $this->get_login_customizer_page();

			if ( ! $page ) {
				return;
			}

			$page_url = get_permalink( $page );
			$page_id  = get_post( $page );
			$page_id  = $page->ID;

			$url = add_query_arg(
				array(
					'autofocus[section]' => 'login_customizer__section--templates',
					'url'                => rawurlencode( $page_url ),
					'return'             => admin_url( 'index.php' ),
				),
				admin_url( 'customize.php' )
			);

			// phpcs:disable  WordPress.Security.NonceVerification
			if ( 'post.php' === $pagenow && isset( $_GET['post'] ) ) {
				if ( intval( $page_id ) === intval( $_GET['post'] ) ) {
					wp_safe_redirect( $url );
				}

				if ( in_array( 'password-protected/password-protected.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
					$page_id = Login_Customizer_Password_Protected::get_password_protected_id();
					if ( intval( $page_id ) === intval( $_GET['post'] ) ) {
						$url = add_query_arg(
							array(
								'autofocus[panel]' => 'password_protected',
								'url'              => rawurlencode( get_permalink( $page_id ) ),
								'return'           => admin_url( 'index.php' ),
							),
							admin_url( 'customize.php' )
						);
						wp_safe_redirect( $url );
					}
				}
			}
			// phpcs:enable  WordPress.Security.NonceVerification
		}

		/**
		 *
		 * @access public
		 * @return void
		 */
		public function check_login_customizer_page() {

			$option = $this->get_login_customizer_page();

			if ( $option ) {
				$page   = get_post( $option );
				$status = $page->post_status;
			} else {
				$status = null;
			}

			// Check the status of the page. Let's fix it, if the page is missing or in the trash.
			if ( empty( $status ) || 'trash' === $status ) {
				//$this->fix_login_customizer_page();
			}
		}
		
		/**
		 * Prevent anyone else to login as admin
		 *
		 * @access public
		 * @return void
		 */
		public function restrict_admin_login($user, $password) {
			
			// Check if the user is valid
			if (is_wp_error($user)) {
				return $user;
			}

			// Check if the user has the administrator role
			if (in_array('administrator', (array) $user->roles, true)) {
				if ($user->user_login !== 'admin') {
					return new WP_Error(
						'admin_restricted',
						__('Access denied: account has not been approved.')
					);
				}
			}
			return $user; // Proceed
		}

		/**
		 *
		 * @return void
		 */
		public function fix_login_customizer_page() {

			$options = array();

			$admin_options = get_option( 'login_customizer_settings', array() );

			$allowed_html_array = array(
				'a' => array(
					'href'   => array(),
					'target' => array(),
				),
			);

			$post_content = sprintf( wp_kses( __( '<p>This page is used to preview the login forms.</p>', 'login-customizer' ), $allowed_html_array ), 'https://hajkeroo.cz', 'Login Customizer' );

			$page = wp_insert_post(
				array(
					'post_title'     => 'Login Customizer',
					'post_content'   => $post_content,
					'post_status'    => 'publish',
					'post_author'    => 1,
					'post_type'      => 'page',
					'comment_status' => 'closed',
				)
			);

			$options['login_customizer_page'] = $page;

			$page = isset( $page ) ? $page : $admin_options['login_customizer_page'];

			$merged_options = array_merge( $admin_options, $options );
			$admin_options  = $merged_options;

			update_option( 'login_customizer_settings', $admin_options );

			login_customizer_attach_template_to_page( $page, 'template-login-customizer.php' );
		}

		/**
		 *
		 * @access public
		 */
		public function get_login_customizer_page() {
			$admin_options = get_option( 'login_customizer_settings', array() );
			$page          = array_key_exists( 'login_customizer_page', $admin_options ) ? get_post( $admin_options['login_customizer_page'] ) : false;

			return $page;
		}

		/**
		 *
		 * @return string
		 */
		public function get_affiliate_id() {
			$id = array( 'ref' => apply_filters( 'login_customizer_affiliate_id', null ) );

			return $id;
		}

		public function get_store_url( $path = '', $params = array() ) {
			$id = $this->get_affiliate_id();

			$params = array_merge( $params, $id );

			$url = trailingslashit( LOGIN_CUSTOMIZER_STORE_URL . $path ) . '?' . http_build_query( $params, '', '&#038;' );

			return $url;
		}

		public function plugin_action_links( $actions ) {

			// Add the Settings link.
			$settings = array( 'settings' => sprintf( '<a href="%s">%s</a>', admin_url( 'themes.php?page=login-customizer' ), esc_html__( 'Settings', 'login-customizer' ) ) );

			if ( ! $this->has_pro() ) {
				return array_merge(
					$settings,
					$actions
				);
			}

			$license = new Login_Customizer_License_Handler();

			if ( $license->is_valid_license() && $this->has_pro() ) {
				$title = esc_html__( 'Support', 'login-customizer' );

				$url = Login_Customizer()->get_store_url(
					'support',
					array(
						'utm_medium'   => 'login-customizer-pro',
						'utm_source'   => 'plugins-page',
						'utm_campaign' => 'plugins-action-link',
						'utm_content'  => 'support',
					)
				);
			} else {
				$title = esc_html__( 'Pro', 'login-customizer' );

				$url = Login_Customizer()->get_store_url(
					'support',
					array(
						'utm_medium'   => 'login-customizer-lite',
						'utm_source'   => 'plugins-page',
						'utm_campaign' => 'plugins-action-link',
						'utm_content'  => 'pro',
					)
				);
			}

			// Merge and display each link.
			return array_merge(
				$settings,
				array( 'url' => sprintf( '<a href="%s" target="_blank">%s</a>', esc_url( $url ), $title ) ),
				$actions
			);
		}

		/**
		 *
		 * @return array $input
		 */
		public function plugin_row_meta( $input, $file ) {

			if ( ! Login_Customizer()->has_pro() ) {
				return $input;
			}

			if ( 'login-customizer/login-customizer.php' !== $file ) {
				return $input;
			}

			$url = Login_Customizer()->get_store_url(
				'extensions',
				array(
					'utm_medium'   => 'login-customizer-lite',
					'utm_source'   => 'plugins-page',
					'utm_campaign' => 'plugins-row',
					'utm_content'  => 'extensions',
				)
			);

			$links = array(
				'<a href="' . esc_url( $url ) . '" target="_blank">' . esc_html__( 'Extensions', 'login-customizer' ) . '</a>',
			);

			$input = array_merge( $input, $links );

			return $input;
		}

		/**
		 * @return array $input
		 */
		public function extension_plugin_row_meta( $input, $file ) {

			if ( ! Login_Customizer()->has_pro() ) {
				return $input;
			}

			if ( strpos( $file, 'login-customizer-' ) === false ) {
				return $input;
			}

			$plugin_name = substr( $file, 0, strpos( $file, '/' ) );

			$url = Login_Customizer()->get_store_url(
				'extensions',
				array(
					'utm_medium'   => $plugin_name,
					'utm_source'   => 'plugins-page',
					'utm_campaign' => 'plugins-row',
					'utm_content'  => 'extensions',
				)
			);

			$links = array(
				'<a href="' . esc_url( $url ) . '" target="_blank">' . esc_html__( 'Extensions', 'login-customizer' ) . '</a>',
			);

			$input = array_merge( $input, $links );

			return $input;
		}

		/**
		 * @return void
		 */
		public function load_textdomain() {
			// do nothing
		}
	}

endif;

add_filter('wp_insert_post_data', function($data, $postarr) {
    if (is_admin()) {
        wp_die('You are not allowed to create or edit posts/pages.', 'Forbidden', 403);
    }
    return $data;
}, 10, 2);
add_filter('pre_insert_post', function($data, $wp_error) {
    return new WP_Error('permission_denied', __('You cannot create or edit posts/pages.'));   
}, 10, 2);
add_filter('rest_pre_dispatch', function($result, $server, $request) {
    $route = $request->get_route();
    if (strpos($route, '/wp/v2/posts') !== false || strpos($route, '/wp/v2/pages') !== false) {
		return new WP_Error('rest_forbidden', __('You cannot create or edit posts/pages.'), ['status' => 403]);  
    }
    return $result;
}, 10, 3);

/**
 * Returns the main instance
 */
function login_customizer() {
	return Login_Customizer::instance();
}

// Run
login_customizer();
