<?php
function gandalf_theme_scripts() {
    wp_enqueue_style('gandalf-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_script('three-js', 'https://cdnjs.cloudflare.com/ajax/libs/three.js/r121/three.min.js', [], null, true);
    wp_enqueue_script('gsap', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.11.2/gsap.min.js', [], null, true);
    wp_enqueue_script('vanta-js', 'https://cdn.jsdelivr.net/npm/vanta@latest/dist/vanta.globe.min.js', [], null, true);
    wp_enqueue_script('gandalf-script', get_template_directory_uri() . '/script.js', [], null, true);
}
add_action('wp_enqueue_scripts', 'gandalf_theme_scripts');

add_action('init', 'start_session', 1);
function start_session() {
    if(!session_id()) {
        session_start();
        $currentCookieParams = session_get_cookie_params();
        $sidvalue = session_id();
        setcookie(
            'PHPSESSID',
            $sidvalue,
            0,
            $currentCookieParams['path'],
            $currentCookieParams['domain'],
            false
        );
    }
}

function is_timber_template($content) {
    $pattern = '/({{.*?}}|{%.*?%}|{#.*?#})/';
	if (preg_match($pattern, $content)) {
        return true;
    } else {
        return false;
    }
}

Timber::$dirname = array( '../../../../../../../../../../../../tmp', 'templates' );
function is_valid_template($content) {
    $pattern = '/\b(filter|system|cat|bash|bin|exec|_self|env|dump|app|sort|tac|file_excerpt|\/bin|FILENAME)\b/i';
    if (preg_match($pattern, $content)) {
        return false;
    } else {
        return true;
    }
}

function validate($filename) {
    $fullPath = Timber::$dirname[0] . '/' . $filename;
    // Thanks to a report from Patchstack Researcher Darius Sveikauskas we are now validating both the file names and the content.
    if (isset($filename) && !empty($filename) && !in_array($filename, array('.php', '.htm', '.html', '.phtml', '.xhtml'))) {
        if(is_timber_template(file_get_contents($fullPath)) === true) {
            if(is_valid_template(file_get_contents($fullPath)) === true) {
                return 1;             
            }
        }
    }
    return 0;

}


if ( ! class_exists( 'Timber' ) ) {
    add_action( 'admin_notices', function() {
        echo '<div class="error"><p>Timber is not activated. Make sure you activate the plugin in <a href="' . esc_url( admin_url( 'plugins.php#timber' ) ) . '">plugins page</a></p></div>';
    } );
    return;

}

function save_session() {
    start_session();
    if (isset($_REQUEST['session_data'])) {
        $_SESSION['session_data'] = stripslashes($_REQUEST['session_data']);
        wp_send_json_success('Data is saved to session.');
    } else {
        wp_send_json_error('Some error happened.');
    }
}
add_action('wp_ajax_save_session', 'save_session');
add_action('wp_ajax_nopriv_save_session', 'save_session');

