/*
 * =====================================================================================
 *
 *       Filename:  Blosum.cpp
 *
 *    Description:  File which has the Blosum matrices hard coded
 *
 *        Version:  1.0
 *        Created:  17/09/2010 11:55:02
 *       Revision:  none
 *       Compiler:  gcc
 *
 *         Author:  Brian E. Caffrey (), brian.caffrey@gmail.com
 *        Company:  Smurfit Institute of Genetics
 *
 * =====================================================================================
 */

#include"Blosum.h"


Blosum Blosum70(){

	Blosum temp62;

	vector<int> temp_val;

	//string str= "A  C  D  E  F  G  H  I  K  L  M  N  P  Q  R  S  T  V  W  Y  -";
	string str= "A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  -";
	vector<string> tokens;
	Tokenize(str, tokens, " ");

	for(unsigned int i=0;i<tokens.size();++i){
		temp62.index[tokens[i]]=i;
	}

	int myints1[] = {4,-2,-2,-2,-1,-1,-1,0,-2,-2,-2,-1,-1,-2,-1,1,0,-3,-2,0,0};
	temp_val.assign(myints1, myints1+21);
	temp62.values.push_back(temp_val);
	int myints2[] = {-2,6,-1,-2,-4,1,0,-3,0,-3,-3,2,-2,-3,-2,-1,-1,-3,-2,-3,0};
	temp_val.assign(myints2, myints2+21);
	temp62.values.push_back(temp_val);
	int myints3[] = {-2,-1,6,1,-3,0,0,-1,0,-4,-4,0,-2,-3,-2,0,0,-4,-2,-3,0};
	temp_val.assign(myints3, myints3+21);
	temp62.values.push_back(temp_val);
	int myints4[] = {-2,-2,1,6,-4,-1,1,-2,-1,-4,-4,-1,-3,-4,-2,0,-1,-5,-4,-4,0};
	temp_val.assign(myints4, myints4+21);
	temp62.values.push_back(temp_val);
	int myints5[] = {-1,-4,-3,-4,9,-3,-4,-3,-4,-1,-2,-4,-2,-2,-3,-1,-1,-3,-3,-1,0};
	temp_val.assign(myints5, myints5+21);
	temp62.values.push_back(temp_val);
	int myints6[] = {-1,1,0,-1,-3,6,2,-2,1,-3,-2,1,0,-3,-2,0,-1,-2,-2,-2,0};
	temp_val.assign(myints6, myints6+21);
	temp62.values.push_back(temp_val);
	int myints7[] = {-1,0,0,1,-4,2,5,-2,0,-4,-3,1,-2,-4,-1,0,-1,-4,-3,-3,0};
	temp_val.assign(myints7, myints7+21);
	temp62.values.push_back(temp_val);
	int myints8[] = {0,-3,-1,-2,-3,-2,-2,6,-2,-4,-4,-2,-3,-4,-3,-1,-2,-3,-4,-4,0};
	temp_val.assign(myints8, myints8+21);
	temp62.values.push_back(temp_val);
	int myints9[] = {-2,0,0,-1,-4,1,0,-2,8,-4,-3,-1,-2,-1,-2,-1,-2,-2,2,-3,0};
	temp_val.assign(myints9, myints9+21);
	temp62.values.push_back(temp_val);
	int myints10[] = {-2,-3,-4,-4,-1,-3,-4,-4,-4,4,2,-3,1,0,-3,-3,-1,-3,-1,3,0};
	temp_val.assign(myints10, myints10+21);
	temp62.values.push_back(temp_val);
	int myints11[] = {-2,-3,-4,-4,-2,-2,-3,-4,-3,2,4,-3,2,0,-3,-3,-2,-2,-1,1,0};
	temp_val.assign(myints11, myints11+21);
	temp62.values.push_back(temp_val);
	int myints12[] = {-1,2,0,-1,-4,1,1,-2,-1,-3,-3,5,-2,-3,-1,0,-1,-3,-2,-3,0};
	temp_val.assign(myints12, myints12+21);
	temp62.values.push_back(temp_val);
	int myints13[] = {-1,-2,-2,-3,-2,0,-2,-3,-2,1,2,-2,6,0,-3,-2,-1,-2,-1,1,0};
	temp_val.assign(myints13, myints13+21);
	temp62.values.push_back(temp_val);
	int myints14[] = {-2,-3,-3,-4,-2,-3,-4,-4,-1,0,0,-3,0,6,-4,-3,-2,1,3,-1,0};
	temp_val.assign(myints14, myints14+21);
	temp62.values.push_back(temp_val);
	int myints15[] = {-1,-2,-2,-2,-3,-2,-1,-3,-2,-3,-3,-1,-3,-4,8,-1,-1,-4,-3,-3,0};
	temp_val.assign(myints15, myints15+21);
	temp62.values.push_back(temp_val);
	int myints16[] = {1,-1,0,0,-1,0,0,-1,-1,-3,-3,0,-2,-3,-1,4,1,-3,-2,-2,0};
	temp_val.assign(myints16, myints16+21);
	temp62.values.push_back(temp_val);
	int myints17[] = {0,-1,0,-1,-1,-1,-1,-2,-2,-1,-2,-1,-1,-2,-1,1,5,-3,-2,0,0};
	temp_val.assign(myints17, myints17+21);
	temp62.values.push_back(temp_val);
	int myints18[] = {-3,-3,-4,-5,-3,-2,-4,-3,-2,-3,-2,-3,-2,1,-4,-3,-3,11,2,-3,0};
	temp_val.assign(myints18, myints18+21);
	temp62.values.push_back(temp_val);
	int myints19[] = {-2,-2,-2,-4,-3,-2,-3,-4,2,-1,-1,-2,-1,3,-3,-2,-2,2,7,-2,0};
	temp_val.assign(myints19, myints19+21);
	temp62.values.push_back(temp_val);
	int myints20[] = {0,-3,-3,-4,-1,-2,-3,-4,-3,3,1,-3,1,-1,-3,-2,0,-3,-2,4,0};
	temp_val.assign(myints20, myints20+21);
	temp62.values.push_back(temp_val);
	int myints22[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	temp_val.assign(myints22, myints22+21);
	temp62.values.push_back(temp_val);

	return temp62;

}



Blosum Blosum80(){

	Blosum temp62;

	vector<int> temp_val;

	//string str= "A  C  D  E  F  G  H  I  K  L  M  N  P  Q  R  S  T  V  W  Y  -";
	string str= "A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  -";
	vector<string> tokens;
	Tokenize(str, tokens, " ");

	for(unsigned int i=0;i<tokens.size();++i){
		temp62.index[tokens[i]]=i;
	}


	int myints2[] = {7,-3,-3,-3,-1,-2,-2,0,-3,-3,-3,-1,-2,-4,-1,2,0,-5,-4,-1,0};
	temp_val.assign(myints2, myints2+21);
	temp62.values.push_back(temp_val);
	int myints3[] = {-3,9,-1,-3,-6,1,-1,-4,0,-5,-4,3,-3,-5,-3,-2,-2,-5,-4,-4,0};
	temp_val.assign(myints3, myints3+21);
	temp62.values.push_back(temp_val);
	int myints4[] = {-3,-1,9,2,-5,0,-1,-1,1,-6,-6,0,-4,-6,-4,1,0,-7,-4,-5,0};
	temp_val.assign(myints4, myints4+21);
	temp62.values.push_back(temp_val);
	int myints5[] = {-3,-3,2,10,-7,-1,2,-3,-2,-7,-7,-2,-6,-6,-3,-1,-2,-8,-6,-6,0};
	temp_val.assign(myints5, myints5+21);
	temp62.values.push_back(temp_val);
	int myints6[] = {-1,-6,-5,-7,13,-5,-7,-6,-7,-2,-3,-6,-3,-4,-6,-2,-2,-5,-5,-2,0};
	temp_val.assign(myints6, myints6+21);
	temp62.values.push_back(temp_val);
	int myints7[] = {-2,1,0,-1,-5,9,3,-4,1,-5,-4,2,-1,-5,-3,-1,-1,-4,-3,-4,0};
	temp_val.assign(myints7, myints7+21);
	temp62.values.push_back(temp_val);
	int myints8[] = {-2,-1,-1,2,-7,3,8,-4,0,-6,-6,1,-4,-6,-2,-1,-2,-6,-5,-4,0};
	temp_val.assign(myints8, myints8+21);
	temp62.values.push_back(temp_val);
	int myints9[] = {0,-4,-1,-3,-6,-4,-4,9,-4,-7,-7,-3,-5,-6,-5,-1,-3,-6,-6,-6,0};
	temp_val.assign(myints9, myints9+21);
	temp62.values.push_back(temp_val);
	int myints10[] = {-3,0,1,-2,-7,1,0,-4,12,-6,-5,-1,-4,-2,-4,-2,-3,-4,3,-5,0};
	temp_val.assign(myints10, myints10+21);
	temp62.values.push_back(temp_val);
	int myints11[] = {-3,-5,-6,-7,-2,-5,-6,-7,-6,7,2,-5,2,-1,-5,-4,-2,-5,-3,4,0};
	temp_val.assign(myints11, myints11+21);
	temp62.values.push_back(temp_val);
	int myints12[] = {-3,-4,-6,-7,-3,-4,-6,-7,-5,2,6,-4,3,0,-5,-4,-3,-4,-2,1,0};
	temp_val.assign(myints12, myints12+21);
	temp62.values.push_back(temp_val);
	int myints13[] = {-1,3,0,-2,-6,2,1,-3,-1,-5,-4,8,-3,-5,-2,-1,-1,-6,-4,-4,0};
	temp_val.assign(myints13, myints13+21);
	temp62.values.push_back(temp_val);
	int myints14[] = {-2,-3,-4,-6,-3,-1,-4,-5,-4,2,3,-3,9,0,-4,-3,-1,-3,-3,1,0};
	temp_val.assign(myints14, myints14+21);
	temp62.values.push_back(temp_val);
	int myints15[] = {-4,-5,-6,-6,-4,-5,-6,-6,-2,-1,0,-5,0,10,-6,-4,-4,0,4,-2,0};
	temp_val.assign(myints15, myints15+21);
	temp62.values.push_back(temp_val);
	int myints16[] = {-1,-3,-4,-3,-6,-3,-2,-5,-4,-5,-5,-2,-4,-6,12,-2,-3,-7,-6,-4,0};
	temp_val.assign(myints16, myints16+21);
	temp62.values.push_back(temp_val);
	int myints17[] = {2,-2,1,-1,-2,-1,-1,-1,-2,-4,-4,-1,-3,-4,-2,7,2,-6,-3,-3,0};
	temp_val.assign(myints17, myints17+21);
	temp62.values.push_back(temp_val);
	int myints18[] = {0,-2,0,-2,-2,-1,-2,-3,-3,-2,-3,-1,-1,-4,-3,2,8,-5,-3,0,0};
	temp_val.assign(myints18, myints18+21);
	temp62.values.push_back(temp_val);
	int myints19[] = {-5,-5,-7,-8,-5,-4,-6,-6,-4,-5,-4,-6,-3,0,-7,-6,-5,16,3,-5,0};
	temp_val.assign(myints19, myints19+21);
	temp62.values.push_back(temp_val);
	int myints20[] = {-4,-4,-4,-6,-5,-3,-5,-6,3,-3,-2,-4,-3,4,-6,-3,-3,3,11,-3,0};
	temp_val.assign(myints20, myints20+21);
	temp62.values.push_back(temp_val);
	int myints21[] = {-1,-4,-5,-6,-2,-4,-4,-6,-5,4,1,-4,1,-2,-4,-3,0,-5,-3,7,0};
	temp_val.assign(myints21, myints21+21);
	temp62.values.push_back(temp_val);

	int myints22[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	temp_val.assign(myints22, myints22+21);
	temp62.values.push_back(temp_val);

	return temp62;

}


Blosum Blosum50(){

	Blosum temp62;

	vector<int> temp_val;

	//string str= "A  C  D  E  F  G  H  I  K  L  M  N  P  Q  R  S  T  V  W  Y  -";
	string str= "A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  -";
	vector<string> tokens;
	Tokenize(str, tokens, " ");

	for(unsigned int i=0;i<tokens.size();++i){
		temp62.index[tokens[i]]=i;
	}

	int myints2[] = {5,-2,-1,-2,-1,-1,-1,0,-2,-1,-2,-1,-1,-3,-1,1,0,-3,-2,0,0};
	temp_val.assign(myints2, myints2+21);
	temp62.values.push_back(temp_val);
	int myints3[] = {-2,7,-1,-2,-4,1,0,-3,0,-4,-3,3,-2,-3,-3,-1,-1,-3,-1,-3,0};
	temp_val.assign(myints3, myints3+21);
	temp62.values.push_back(temp_val);
	int myints4[] = {-1,-1,7,2,-2,0,0,0,1,-3,-4,0,-2,-4,-2,1,0,-4,-2,-3,0};
	temp_val.assign(myints4, myints4+21);
	temp62.values.push_back(temp_val);
	int myints5[] = {-2,-2,2,8,-4,0,2,-1,-1,-4,-4,-1,-4,-5,-1,0,-1,-5,-3,-4,0};
	temp_val.assign(myints5, myints5+21);
	temp62.values.push_back(temp_val);
	int myints6[] = {-1,-4,-2,-4,13,-3,-3,-3,-3,-2,-2,-3,-2,-2,-4,-1,-1,-5,-3,-1,0};
	temp_val.assign(myints6, myints6+21);
	temp62.values.push_back(temp_val);
	int myints7[] = {-1,1,0,0,-3,7,2,-2,1,-3,-2,2,0,-4,-1,0,-1,-1,-1,-3,0};
	temp_val.assign(myints7, myints7+21);
	temp62.values.push_back(temp_val);
	int myints8[] = {-1,0,0,2,-3,2,6,-3,0,-4,-3,1,-2,-3,-1,-1,-1,-3,-2,-3,0};
	temp_val.assign(myints8, myints8+21);
	temp62.values.push_back(temp_val);
	int myints9[] = {0,-3,0,-1,-3,-2,-3,8,-2,-4,-4,-2,-3,-4,-2,0,-2,-3,-3,-4,0};
	temp_val.assign(myints9, myints9+21);
	temp62.values.push_back(temp_val);
	int myints10[] = {-2,0,1,-1,-3,1,0,-2,10,-4,-3,0,-1,-1,-2,-1,-2,-3,2,-4,0};
	temp_val.assign(myints10, myints10+21);
	temp62.values.push_back(temp_val);
	int myints11[] = {-1,-4,-3,-4,-2,-3,-4,-4,-4,5,2,-3,2,0,-3,-3,-1,-3,-1,4,0};
	temp_val.assign(myints11, myints11+21);
	temp62.values.push_back(temp_val);
	int myints12[] = {-2,-3,-4,-4,-2,-2,-3,-4,-3,2,5,-3,3,1,-4,-3,-1,-2,-1,1,0};
	temp_val.assign(myints12, myints12+21);
	temp62.values.push_back(temp_val);
	int myints13[] = {-1,3,0,-1,-3,2,1,-2,0,-3,-3,6,-2,-4,-1,0,-1,-3,-2,-3,0};
	temp_val.assign(myints13, myints13+21);
	temp62.values.push_back(temp_val);
	int myints14[] = {-1,-2,-2,-4,-2,0,-2,-3,-1,2,3,-2,7,0,-3,-2,-1,-1,0,1,0};
	temp_val.assign(myints14, myints14+21);
	temp62.values.push_back(temp_val);
	int myints15[] = {-3,-3,-4,-5,-2,-4,-3,-4,-1,0,1,-4,0,8,-4,-3,-2,1,4,-1,0};
	temp_val.assign(myints15, myints15+21);
	temp62.values.push_back(temp_val);
	int myints16[] = {-1,-3,-2,-1,-4,-1,-1,-2,-2,-3,-4,-1,-3,-4,10,-1,-1,-4,-3,-3,0};
	temp_val.assign(myints16, myints16+21);
	temp62.values.push_back(temp_val);
	int myints17[] = {1,-1,1,0,-1,0,-1,0,-1,-3,-3,0,-2,-3,-1,5,2,-4,-2,-2,0};
	temp_val.assign(myints17, myints17+21);
	temp62.values.push_back(temp_val);
	int myints18[] = {0,-1,0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1,2,5,-3,-2,0,0};
	temp_val.assign(myints18, myints18+21);
	temp62.values.push_back(temp_val);
	int myints19[] = {-3,-3,-4,-5,-5,-1,-3,-3,-3,-3,-2,-3,-1,1,-4,-4,-3,15,2,-3,0};
	temp_val.assign(myints19, myints19+21);
	temp62.values.push_back(temp_val);
	int myints20[] = {-2,-1,-2,-3,-3,-1,-2,-3,2,-1,-1,-2,0,4,-3,-2,-2,2,8,-1,0};
	temp_val.assign(myints20, myints20+21);
	temp62.values.push_back(temp_val);
	int myints21[] = {0,-3,-3,-4,-1,-3,-3,-4,-4,4,1,-3,1,-1,-3,-2,0,-3,-1,5,0};
	temp_val.assign(myints21, myints21+21);
	temp62.values.push_back(temp_val);
	int myints22[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	temp_val.assign(myints22, myints22+21);
	temp62.values.push_back(temp_val);

	return temp62;

}



Blosum Blosum45(){

	Blosum temp62;

	vector<int> temp_val;

	//string str= "A  C  D  E  F  G  H  I  K  L  M  N  P  Q  R  S  T  V  W  Y  -";
	string str= "A  R  N  D  C  Q  E  G  H  I  L  K  M  F  P  S  T  W  Y  V  -";
	vector<string> tokens;
	Tokenize(str, tokens, " ");

	for(unsigned int i=0;i<tokens.size();++i){
		temp62.index[tokens[i]]=i;
	}

	int myints2[] = {5,-2,-1,-2,-1,-1,-1,0,-2,-1,-1,-1,-1,-2,-1,1,0,-2,-2,0,0};
	temp_val.assign(myints2, myints2+21);
	temp62.values.push_back(temp_val);
	int myints3[] = {-2,7,0,-1,-3,1,0,-2,0,-3,-2,3,-1,-2,-2,-1,-1,-2,-1,-2,0};
	temp_val.assign(myints3, myints3+21);
	temp62.values.push_back(temp_val);
	int myints4[] = {-1,0,6,2,-2,0,0,0,1,-2,-3,0,-2,-2,-2,1,0,-4,-2,-3,0};
	temp_val.assign(myints4, myints4+21);
	temp62.values.push_back(temp_val);
	int myints5[] = {-2,-1,2,7,-3,0,2,-1,0,-4,-3,0,-3,-4,-1,0,-1,-4,-2,-3,0};
	temp_val.assign(myints5, myints5+21);
	temp62.values.push_back(temp_val);
	int myints6[] = {-1,-3,-2,-3,12,-3,-3,-3,-3,-3,-2,-3,-2,-2,-4,-1,-1,-5,-3,-1,0};
	temp_val.assign(myints6, myints6+21);
	temp62.values.push_back(temp_val);
	int myints7[] = {-1,1,0,0,-3,6,2,-2,1,-2,-2,1,0,-4,-1,0,-1,-2,-1,-3,0};
	temp_val.assign(myints7, myints7+21);
	temp62.values.push_back(temp_val);
	int myints8[] = {-1,0,0,2,-3,2,6,-2,0,-3,-2,1,-2,-3,0,0,-1,-3,-2,-3,0};
	temp_val.assign(myints8, myints8+21);
	temp62.values.push_back(temp_val);
	int myints9[] = {0,-2,0,-1,-3,-2,-2,7,-2,-4,-3,-2,-2,-3,-2,0,-2,-2,-3,-3,0};
	temp_val.assign(myints9, myints9+21);
	temp62.values.push_back(temp_val);
	int myints10[] = {-2,0,1,0,-3,1,0,-2,10,-3,-2,-1,0,-2,-2,-1,-2,-3,2,-3,0};
	temp_val.assign(myints10, myints10+21);
	temp62.values.push_back(temp_val);
	int myints11[] = {-1,-3,-2,-4,-3,-2,-3,-4,-3,5,2,-3,2,0,-2,-2,-1,-2,0,3,0};
	temp_val.assign(myints11, myints11+21);
	temp62.values.push_back(temp_val);
	int myints12[] = {-1,-2,-3,-3,-2,-2,-2,-3,-2,2,5,-3,2,1,-3,-3,-1,-2,0,1,0};
	temp_val.assign(myints12, myints12+21);
	temp62.values.push_back(temp_val);
	int myints13[] = {-1,3,0,0,-3,1,1,-2,-1,-3,-3,5,-1,-3,-1,-1,-1,-2,-1,-2,0};
	temp_val.assign(myints13, myints13+21);
	temp62.values.push_back(temp_val);
	int myints14[] = {-1,-1,-2,-3,-2,0,-2,-2,0,2,2,-1,6,0,-2,-2,-1,-2,0,1,0};
	temp_val.assign(myints14, myints14+21);
	temp62.values.push_back(temp_val);
	int myints15[] = {-2,-2,-2,-4,-2,-4,-3,-3,-2,0,1,-3,0,8,-3,-2,-1,1,3,0,0};
	temp_val.assign(myints15, myints15+21);
	temp62.values.push_back(temp_val);
	int myints16[] = {-1,-2,-2,-1,-4,-1,0,-2,-2,-2,-3,-1,-2,-3,9,-1,-1,-3,-3,-3,0};
	temp_val.assign(myints16, myints16+21);
	temp62.values.push_back(temp_val);
	int myints17[] = {1,-1,1,0,-1,0,0,0,-1,-2,-3,-1,-2,-2,-1,4,2,-4,-2,-1,0};
	temp_val.assign(myints17, myints17+21);
	temp62.values.push_back(temp_val);
	int myints18[] = {0,-1,0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1,2,5,-3,-1,0,0};
	temp_val.assign(myints18, myints18+21);
	temp62.values.push_back(temp_val);
	int myints19[] = {-2,-2,-4,-4,-5,-2,-3,-2,-3,-2,-2,-2,-2,1,-3,-4,-3,15,3,-3,0};
	temp_val.assign(myints19, myints19+21);
	temp62.values.push_back(temp_val);
	int myints20[] = {-2,-1,-2,-2,-3,-1,-2,-3,2,0,0,-1,0,3,-3,-2,-1,3,8,-1,0};
	temp_val.assign(myints20, myints20+21);
	temp62.values.push_back(temp_val);
	int myints21[] = {0,-2,-3,-3,-1,-3,-3,-3,-3,3,1,-2,1,0,-3,-1,0,-3,-1,5,0};
	temp_val.assign(myints21, myints21+21);
	temp62.values.push_back(temp_val);
	int myints22[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	temp_val.assign(myints22, myints22+21);
	temp62.values.push_back(temp_val);

	return temp62;

}





Blosum Blosum62(){

	Blosum temp62;

	vector<int> temp_val;

	string str= "A  C  D  E  F  G  H  I  K  L  M  N  P  Q  R  S  T  V  W  Y  -";
	vector<string> tokens;
	Tokenize(str, tokens, " ");

	for(unsigned int i=0;i<tokens.size();++i){
		temp62.index[tokens[i]]=i;
	}

	int myints[] = {4,0,-2,-1,-2,0,-2,-1,-1,-1,-1,-2,-1,-1,-1,1,0,0,-3,-2,0};
	temp_val.assign(myints, myints+21);
	temp62.values.push_back(temp_val);

	int myints1[] = {0,9,-3,-4,-2,-3,-3,-1,-3,-1,-1,-3,-3,-3,-3,-1,-1,-1,-2,-2,0};
	temp_val.assign(myints1, myints1+21);
	temp62.values.push_back(temp_val);
	int myints2[] = {-2,-3,6,2,-3,-1,-1,-3,-1,-4,-3,1,-1,0,-2,0,-1,-3,-4,-3,0};
	temp_val.assign(myints2, myints2+21);
	temp62.values.push_back(temp_val);
	int myints3[] = {-1,-4,2,5,-3,-2,0,-3,1,-3,-2,0,-1,2,0,0,-1,-2,-3,-2,0};
	temp_val.assign(myints3, myints3+21);
	temp62.values.push_back(temp_val);
	int myints4[] = {-2,-2,-3,-3,6,-3,-1,0,-3,0,0,-3,-4,-3,-3,-2,-2,-1,1,3,0};
	temp_val.assign(myints4, myints4+21);
	temp62.values.push_back(temp_val);
	int myints5[] = {0,-3,-1,-2,-3,6,-2,-4,-2,-4,-3,0,-2,-2,-2,0,-2,-3,-2,-3,0};
	temp_val.assign(myints5, myints5+21);
	temp62.values.push_back(temp_val);
	int myints6[] = {-2,-3,-1,0,-1,-2,8,-3,-1,-3,-2,1,-2,0,0,-1,-2,-3,-2,2,0};
	temp_val.assign(myints6, myints6+21);
	temp62.values.push_back(temp_val);
	int myints7[] = {-1,-1,-3,-3,0,-4,-3,4,-3,2,1,-3,-3,-3,-3,-2,-1,3,-3,-1,0};
	temp_val.assign(myints7, myints7+21);
	temp62.values.push_back(temp_val);
	int myints8[] = {-1,-3,-1,1,-3,-2,-1,-3,5,-2,-1,0,-1,1,2,0,-1,-2,-3,-2,0};
	temp_val.assign(myints8, myints8+21);
	temp62.values.push_back(temp_val);
	int myints9[] = {-1,-1,-4,-3,0,-4,-3,2,-2,4,2,-3,-3,-2,-2,-2,-1,1,-2,-1,0};
	temp_val.assign(myints9, myints9+21);
	temp62.values.push_back(temp_val);
	int myints10[] = {-1,-1,-3,-2,0,-3,-2,1,-1,2,5,-2,-2,0,-1,-1,-1,1,-1,-1,0};
	temp_val.assign(myints10, myints10+21);
	temp62.values.push_back(temp_val);
	int myints11[] = {-2,-3,1,0,-3,0,1,-3,0,-3,-2,6,-2,0,0,1,0,-3,-4,-2,0};
	temp_val.assign(myints11, myints11+21);
	temp62.values.push_back(temp_val);
	int myints12[] = {-1,-3,-1,-1,-4,-2,-2,-3,-1,-3,-2,-2,7,-1,-2,-1,-1,-2,-4,-3,0};
	temp_val.assign(myints12, myints12+21);
	temp62.values.push_back(temp_val);
	int myints13[] = {-1,-3,0,2,-3,-2,0,-3,1,-2,0,0,-1,5,1,0,-1,-2,-2,-1,0};
	temp_val.assign(myints13, myints13+21);
	temp62.values.push_back(temp_val);
	int myints14[] = {-1,-3,-2,0,-3,-2,0,-3,2,-2,-1,0,-2,1,5,-1,-1,-3,-3,-2,0};
	temp_val.assign(myints14, myints14+21);
	temp62.values.push_back(temp_val);
	int myints15[] = {1,-1,0,0,-2,0,-1,-2,0,-2,-1,1,-1,0,-1,4,1,-2,-3,-2,0};
	temp_val.assign(myints15, myints15+21);
	temp62.values.push_back(temp_val);
	int myints16[] = {0,-1,-1,-1,-2,-2,-2,-1,-1,-1,-1,0,-1,-1,-1,1,5,0,-2,-2,0};
	temp_val.assign(myints16, myints16+21);
	temp62.values.push_back(temp_val);
	int myints17[] = {0,-1,-3,-2,-1,-3,-3,3,-2,1,1,-3,-2,-2,-3,-2,0,4,-3,-1,0};
	temp_val.assign(myints17, myints17+21);
	temp62.values.push_back(temp_val);
	int myints18[] = {-3,-2,-4,-3,1,-2,-2,-3,-3,-2,-1,-4,-4,-2,-3,-3,-2,-3,11,2,0};
	temp_val.assign(myints18, myints18+21);
	temp62.values.push_back(temp_val);
	int myints19[] = {-2,-2,-3,-2,3,-3,2,-1,-2,-1,-1,-2,-3,-1,-2,-2,-2,-1,2,7,0};
	temp_val.assign(myints19, myints19+21);
	temp62.values.push_back(temp_val);
	int myints20[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	temp_val.assign(myints20, myints20+21);
	temp62.values.push_back(temp_val);

	return temp62;

}

void Blosum::print(const char * filename){

	ofstream file1(filename);


	if(file1.is_open()){
	}else{
		cerr << "Error: couldn't open file " << filename << endl;
		exit(-1);
	}


	map<string, int>::iterator myit, myit1;
	for(myit=index.begin();myit!=index.end();++myit){
		file1 << myit->first << "\t";		
	}
	file1 << endl;
	for(myit=index.begin();myit!=index.end();++myit){
		for(myit1=index.begin();myit1!=index.end();++myit1){
			file1 << values[index[myit->first]][index[myit1->first]] << "\t";
		}
		file1 << endl;
	}	

	file1.close();

}

