#include"create.h"
#include<Phyl/DistanceEstimation.h>

/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  create_seq
 *  Description:  create sequences for simultaionts 
 * =====================================================================================
 */
void create_seq(TreeTemplate<Node>*& mytree, vector<string>& Tname, vector<string>& tseqs, unsigned int length)
{


	DiscreteDistribution * rDist = new GammaDiscreteDistribution(4, 0.5);
	Alphabet * alphabet = new ProteicAlphabet(); 

	SubstitutionModel  * model = new JTT92(dynamic_cast<ProteicAlphabet *>(alphabet)); 

	FullFrequenciesSet* fSet = new FullFrequenciesSet(model->getAlphabet());
	fSet->setFrequencies(model->getFrequencies());
	SubstitutionModelSet *modelSet = SubstitutionModelSetTools::createHomogeneousModelSet(dynamic_cast<SubstitutionModel*>(model->clone()), fSet, mytree);
	NonHomogeneousSequenceSimulator seqsim(modelSet, rDist, mytree);
	std::auto_ptr<SiteContainer> sites(seqsim.simulate(length));

	Tname = sites->getSequencesNames();
	for(unsigned int i=0;i<Tname.size();++i){
		const Sequence myseq=sites->getSequence(Tname[i]);
		tseqs.push_back(myseq.toString());
	}

	delete modelSet;
	delete model;
	delete alphabet;
	delete rDist;
}

/* -----  end of function create_seq  ----- */




/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  ScoreDist
 *  Description:  Get the Distance matrix for a set of alignments according to JTT model 
 * =====================================================================================
 */

std::auto_ptr<DistanceMatrix> ScoreDist(vector<string>& names, vector< string >& sequences){

	FILE *stream;
	stream = freopen("/dev/null", "w", stdout);
	std::auto_ptr<DistanceMatrix> DS;
	Alphabet *alphabet = new ProteicAlphabet();
	DiscreteDistribution * rdist = new GammaDiscreteDistribution(4, 0.5);
	const ProteicAlphabet * alpha = dynamic_cast<const ProteicAlphabet *>(alphabet);
	SubstitutionModel * model = new JTT92(alpha);
	VectorSequenceContainer *vsc = new VectorSequenceContainer(alpha);


	int nam_siz=names.size();	
	for(int i=0;i<nam_siz;++i){
		std::string mystr(sequences[i]);
		std::string tem(names[i]);
		vsc->addSequence(Sequence(names[i], sequences[i], alphabet));
	}

	VectorSiteContainer * sites = new VectorSiteContainer(alphabet);

	for(int i=0;i<nam_siz;++i){
		const Sequence myseq=  vsc->getSequence(names[i]);
		sites->addSequence(myseq, true);	
	}

	model->setFreqFromData(*sites);


	SiteContainerTools::changeGapsToUnknownCharacters(*sites);
	DistanceEstimation  MyDS(model, rdist, sites, 1, true);

	delete sites;
	delete vsc;
	delete model;
	DS = (std::auto_ptr<DistanceMatrix>)(MyDS.getMatrix());
	delete rdist;
	delete alphabet;

	return DS;
}

/* -----  end of function ScoreDist  ----- */

string nuc_to_amino(string nuc){


	string prot;
	codon mycod;
	mycod.initialise();

	for(unsigned int i=0;i<nuc.size();i+=3){

		string temp;
		temp += nuc[i];
		temp += nuc[i+1];
		temp += nuc[i+2];

		prot += mycod.convert[temp];

	}


	return prot;
}



void codon::initialise(){


	convert["ATG"]='M';
	convert["TAA"]='-';
	convert["TAG"]='-';
	convert["TGA"]='-';
	convert["TGG"]='W';

	convert["TTT"]='F';	
	convert["TTC"]='F';	
	convert["TAT"]='Y';	
	convert["TAC"]='Y';	
	convert["CAT"]='H';	
	convert["CAC"]='H';	
	convert["CAA"]='Q';	
	convert["CAG"]='Q';	
	convert["AAA"]='K';	
	convert["AAG"]='K';	
	convert["GAT"]='D';	
	convert["GAC"]='D';	
	convert["GAA"]='E';	
	convert["GAG"]='E';	
	convert["AAT"]='N';	
	convert["AAC"]='N';	
	convert["TGT"]='C';	
	convert["TGC"]='C';	

	convert["ATT"]='I';	
	convert["ATC"]='I';	
	convert["ATA"]='I';	
	convert["GTA"]='V';	
	convert["GTT"]='V';	
	convert["GTC"]='V';	
	convert["GTG"]='V';	
	convert["CCA"]='P';	
	convert["CCT"]='P';	
	convert["CCC"]='P';	
	convert["CCG"]='P';	
	convert["ACA"]='T';	
	convert["ACT"]='T';	
	convert["ACC"]='T';	
	convert["ACG"]='T';	
	convert["GCA"]='A';	
	convert["GCT"]='A';	
	convert["GCC"]='A';	
	convert["GCG"]='A';	
	convert["GGA"]='G';	
	convert["GGT"]='G';	
	convert["GGC"]='G';	
	convert["GGG"]='G';	

	convert["TTA"]='L';	
	convert["TTG"]='L';	
	convert["CTA"]='L';	
	convert["CTT"]='L';	
	convert["CTC"]='L';	
	convert["CTG"]='L';	
	convert["TCA"]='S';	
	convert["TCT"]='S';	
	convert["TCC"]='S';	
	convert["TCG"]='S';	
	convert["AGT"]='S';	
	convert["AGC"]='S';	
	convert["AGA"]='R';	
	convert["AGG"]='R';	
	convert["CGA"]='R';	
	convert["CGT"]='R';	
	convert["CGC"]='R';	
	convert["CGG"]='R';	


}

