﻿# Get TLS registry settings that Enable TLS 1.1/1.2 and Disable Legacy SSL. 
#
#

$servers = get-content C:\temp\servers.txt

$get=get-command C:\temp\get-tls.ps1 | select -ExpandProperty ScriptBlock
#$set=get-command C:\temp\set-tls.ps1 | select -ExpandProperty ScriptBlock
#$all=get-command C:\temp\all-tls.ps1 | select -ExpandProperty ScriptBlock

foreach ($server in $servers) {
    Write-Host 
    Write-Host 
    Write-Host -backgroundcolor yellow -foregroundcolor black $server
    Try {
        $session = New-PSSession -ComputerName $server
        Invoke-Command -Session $session -ScriptBlock $get
        Remove-PSSession $session
        }
    Catch {
        write-host -foregroundcolor Magenta "Error! $_"
        }
}
