﻿# Powershell Script to Define and Deploy the Subscriptions
# manually run this when building a new WEC Collector server

# Set the Service to Automatic and Start it
Write-Output "Starting the Windows Event Collector Service"
Start-Service wecsvc
Set-Service wecsvc -StartupType Automatic

# Create the Event Subscriptions
# Make sure the path to the XML files is correct below
Write-Output "Creating custom event subscriptions"
cd C:\WEC-Subscriptions
# this will create the subscriptions but not configure the file location
# it will give an expected error message
cmd /c "for /r %i in (*.xml) do wecutil cs %i"
Write-Output "Enabling custom event subscriptions"
cmd /c "for /r %i in (*.xml) do wecutil ss %~ni /e:true"