# Continuata Bridge

A lightweight cross-platform desktop tray application that acts as a bridge between the Continuata web-based download app and the local file system for browsers that don't support the File System Access API (Safari, Firefox).

## Features

- **Cross-platform system tray application** for Windows, macOS, and Linux
- **HTTP/WebSocket server** for communication with web applications
- **Chunked downloads** with resume capability and SHA-256 verification
- **Real-time progress updates** via WebSocket
- **Automatic download path management**
- **Background operation** with minimal resource usage

## Supported Browsers

| Browser | Direct Download | Bridge Required |
|---------|----------------|-----------------|
| Chrome | ✅ | ❌ |
| Edge | ✅ | ❌ |
| Safari | ❌ | ✅ |
| Firefox | ❌ | ✅ |

## Installation

### Homebrew (macOS)

```bash
brew install continuata/tap/continuata-bridge
```

### Download Pre-built Binaries

1. Go to the [Releases](https://github.com/continuata/tray-bridge/releases) page
2. Download the appropriate binary for your platform:
   - Windows: `continuata-bridge-<version>-windows-amd64.zip`
   - macOS (Intel): `continuata-bridge-<version>-darwin-amd64.tar.gz`
   - macOS (Apple Silicon): `continuata-bridge-<version>-darwin-arm64.tar.gz`
   - Linux: `continuata-bridge-<version>-linux-amd64.tar.gz`

### Build from Source

#### Prerequisites

- Go 1.21 or later
- Make (optional, for using Makefile)

#### Build Steps

```bash
# Clone the repository
git clone https://github.com/continuata/tray-bridge.git
cd tray-bridge

# Install dependencies
go mod tidy

# Build for current platform
make build
```

## Usage

### Starting the Bridge

1. **Double-click the executable** or run from command line:
   ```bash
   ./continuata-bridge
   ```

2. **System tray icon** will appear with the Continuata logo
3. **Server automatically starts** on port 8765
4. **Ready to receive** download requests from web applications

### System Tray Menu

- **Status**: Shows current server status (Ready, Running, Error)
- **Start/Stop Server**: Control the bridge server
- **Download Path**: Shows current download directory
- **Change Download Path**: Select a different download directory
- **Quit**: Exit the application

### Web Integration

When using Safari or Firefox on a Continuata download page:

1. The web app **automatically detects** browser compatibility
2. **Bridge connection check** happens automatically
3. If bridge is available, **download proceeds seamlessly**
4. If bridge is not running, **installation prompt** appears

## API Endpoints

The bridge exposes the following HTTP endpoints:

- `GET /health` - Health check and version info
- `POST /download` - Start a new download
- `GET /progress` - Get current download progress
- `GET /ws` - WebSocket endpoint for real-time updates

## Configuration

### Default Settings

- **Server Port**: 8765
- **Download Path**: `~/Downloads/Continuata`
- **Max Connections**: 4
- **Chunk Retry Limit**: 3

### Environment Variables

- `BRIDGE_PORT` - Override default port
- `BRIDGE_DOWNLOAD_PATH` - Override default download path
- `BRIDGE_MAX_CONNECTIONS` - Override connection limit
- `BRIDGE_ALLOWED_ORIGINS` - Comma-separated list of allowed CORS/WebSocket origins. Defaults to Continuata production domains and common localhost dev ports.
- `BRIDGE_TLS_CERT` and `BRIDGE_TLS_KEY` - If both are set, the bridge serves HTTPS/WSS on `127.0.0.1:<port>` using the provided certificate and key.

### HTTPS/TLS on localhost

To enable secure transport (required for Safari when the page is HTTPS):

1. Generate a trusted localhost certificate (e.g., with `mkcert`):
   - `mkcert -install`
   - `mkcert localhost 127.0.0.1 ::1`
2. Set env vars to the generated files and run the bridge:
   - `BRIDGE_TLS_CERT=./localhost.pem`
   - `BRIDGE_TLS_KEY=./localhost-key.pem`
3. The bridge will listen on `https://127.0.0.1:8765` and expose `wss://127.0.0.1:8765/ws`.

## Security

- **Localhost only** - Server binds to `127.0.0.1` only
- **CORS allowlist** - Only trusted Continuata domains (and configured dev origins) are allowed
- **Private Network Access** - Preflights requesting private network access are granted via `Access-Control-Allow-Private-Network: true`
- **HTTPS/WSS support** - Optional TLS on localhost via `BRIDGE_TLS_CERT`/`BRIDGE_TLS_KEY`
- **No persistent storage** of sensitive data
- **SHA-256 verification** for all downloaded chunks

## Development

### Project Structure

```
tray-bridge/
├── main.go              # Application entry point and tray setup
├── server.go            # HTTP/WebSocket server implementation
├── downloader.go        # Download manager with chunking
├── assets/              # Icon and static assets
├── build/              # Local build artifacts
└── dist/               # Release artifacts (created by CI)
```

### Development Commands

```bash
# Run development build
make run

# Run tests
make test

# Run linter
make lint

# Generate icons from SVG
make icons

# Clean build artifacts
make clean
```

### Adding Features

1. **Modify core functionality** in respective .go files
2. **Update API contracts** in server.go
3. **Add tests** for new functionality
4. **Update documentation** as needed

### Releases

Releases are built and published by GoReleaser via GitHub Actions.

To cut a release, tag and push:

```bash
git tag v1.0.1
git push origin v1.0.1
```

CI will build for Windows/macOS/Linux and upload archives and checksums.

## Troubleshooting

### Bridge Not Connecting

1. **Check if running**: Look for tray icon
2. **Port conflicts**: Ensure port 8765 is available
3. **Firewall**: Allow local connections on port 8765
4. **Restart bridge**: Quit and restart the application

### Download Issues

1. **Check internet connection**
2. **Verify download path** permissions
3. **Check available disk space**
4. **Review logs** in system tray menu

### Platform-Specific Issues

#### macOS
- **Gatekeeper**: Right-click → Open first time
- **Permissions**: May need to grant file access permissions

#### Windows
- **Windows Defender**: May flag as unknown application
- **Admin rights**: May be required for some download paths

#### Linux
- **Dependencies**: Ensure GTK libraries are installed
- **Display server**: Works with both X11 and Wayland

## License

MIT License - see LICENSE file for details.

## Support

- **GitHub Issues**: Report bugs and feature requests
- **Documentation**: Check this README and inline code comments
- **Community**: Join discussions in GitHub Discussions
