%%

% 信号的产生
% 试用MATLAB绘制如下函数的时域波形。

% (1) 单位矩形脉冲函数(门函数) g_6(t)。

t = -5:0.01:5;
y = ((t > -3) & (t < 3)) + 0;
figure(1);
plot(t, y);
title('门函数g_6(t)');
axis([-4 4 -1 2]);

%%

% (2) 单位冲激函数δ(t)的近似值。
% δ(t)用宽度为τ而幅值为1/τ当τ→0时的矩形脉冲函数来近似。
% 分别取τ=0.2, 0.1。

t = -2:0.001:2;
tau_1 = 0.2;
tau_2 = 0.1;
y_1 = ((t > -tau_1 / 2) & (t < tau_1 / 2)) * 1 / tau_1 + 0;
y_2 = ((t > -tau_2 / 2) & (t < tau_2 / 2)) * 1 / tau_2 + 0;
figure(2);
subplot(1, 2, 1);
plot(t, y_1);
title('\tau=0.2');
axis([-0.5 0.5 -1 6]);
subplot(1, 2, 2);
plot(t, y_2);
title('\tau=0.1');
axis([-0.25 0.25 -2 12]);

%% 

% (3) 绘制出f_1(t)和f_2(t)的波形，并求出信号的周期。
% f_1(t)=5*cos(12πt)+6*cos(18πt) 
% f_2(t)=cos^2(2πt)

t = -3:0.01:3;
f_1 = 5 * cos(12 * pi .* t) + 6 * cos(18 * pi .* t);
f_2 = cos(2 * pi .* t) .* cos(2 * pi .* t);
figure(3);
subplot(2, 1, 1);
plot(t, f_1);
title('f_1(t)=5cos(12\pit)+6cos(18\pit)');
axis([-1 1 -12 14]);
subplot(2, 1, 2);
plot(t, f_2);
title('f_2(t)=cos^2(2\pi t)');
axis([-1 1 -1 2]);

