%%
% 连续时间系统的响应

% (1) 使用step函数，求系统的单位阶跃响应g(t)。
%  a. H(p)=(p+5)/(p^2+5p+6)
%  b. H(p)=(p+5)/(p^2+2p+5)
%  c. H(p)=(p+5)/(p^2+2p+1)
% 比较几种情况，在一张图上画出这三个信号

t = 0:0.01:10;
a1 = [1, 5, 6];
a2 = [1, 2, 5];
a3 = [1, 2, 1];
b  = [0, 1, 5];
y1 = step(b, a1, t);
y2 = step(b, a2, t);
y3 = step(b, a3, t);
figure(1);
plot(t,y1,t,y2,'--',t,y3,'+');
title('单位阶跃响应');

%%

% (2) 已知系统y"(t)+3y'(t)+2y(t)=-f'(t)+2f(t)
% 计算系统的单位冲激响应h(t)
% 及在输入信号为f(t)=costu(t)时的系统零状态响应y(t)。

t = 0:0.01:10;
a = [1,  3, 2, 0];
b = [0, -1, 2. 0];
f = cos(t);
y1 = impulse(b, a, t);
y2 = lsim(b, a, f ,t);
figure(2);
subplot(2, 1, 1);
plot(t, y1);
title('单位阶跃响应');
subplot(2, 1, 2);
plot(t, y2);
title('零状态响应');

