%% 周期信号的分析 

% 求T=2pi的三角波信号的傅里叶级数 

syms t n T;
f1 = 1 + 4/T * t;
f2 = 1 - 4/T * t;
a0 = 1/T * (int(f1, -T/2, 0) + int(f2, 0, T/2));
an = 2/T * (int(f1 * cos(n * 2 * pi / T * t), -T/2, 0) + int(f2 * cos(n * 2 * pi / T * t), 0, T/2));
bn = 2/T * (int(f1 * sin(n * 2 * pi / T * t), -T/2, 0) + int(f2 * sin(n * 2 * pi / T * t), 0, T/2));

% 绘制频谱图 

T = 2 * pi;
a = ones(1, 11);
a(1) = a0;
for k = 2:11
    n = k - 1;
    a(k) = subs(an);
end
k = 0 : 10;
stem(k, abs(a), "filled");
grid on;
title('频谱图');
xlabel('k');
ylabel('|a(k)|');
grid on;

