%% 非周期信号的分析

% 绘出f(t)=e^{-3t}u(t)的时域波形和频谱图

syms t;
y = exp(-3 * t) * heaviside(t);
figure(1);
subplot(2, 2, [1, 2]);
fplot(t, y);
title("f(t)=e^{-3t}u(t)");
axis([0, 2, 0, 1]);
grid on;

F = fourier(y);
subplot(2, 2, 3);
fplot(abs(F));
title("|H(j\omega)|");
grid on;

im = imag(F);
re = real(F);
phase = deg2rad(atan(im/re));
subplot(2, 2, 4);
fplot(phase);
title("\phi/rad");
grid on;

%%
% F(jw)的傅立叶逆变换的时域波形和频谱图 (取\tau=3)

syms omega;
tau = 3;
Sa = sin(omega * tau / 2) / (omega * tau / 2);
F = tau * Sa;
figure(2);
subplot(2, 2, 1);
fplot(omega, F);
title("F(j\omega)=\tauSa(\omega\tau/2)");
axis([-5, 5, -1, 3.5]);
grid on;

y = ifourier(F);
subplot(2, 2, 2);
fplot(y);
title("f(t)");
axis([-3, 3, -0.5, 1.5]);
grid on;

F = fourier(y);
subplot(2, 2, 3);
fplot(abs(F));
title("|H(j\omega)|");
axis([-10, 10, -0.5, 3.5]);
grid on;

phase = angle(F);
subplot(2, 2, 4);
fplot(phase);
title("\phi/rad");
axis([-10, 10, -0.5, 3.5]);
grid on;
