%% 连续时间系统的相应
% 系统的传递函数为H(jw)=(1-jw)/(1+jw)
% 绘制幅度相应和相位相应曲线 分析频率特性 判断是否为无失真传输
% 求系统单位冲激响应
% 求输入为f(t)=e^{-2t}u(t)时的零状态响应 绘制输入信号与相应的波形

w = -5 : 0.01 : 5;
b = [-1 1];
a = [1 1];
h = freqs(b, a, w);

figure(1);
subplot(2, 1, 1);
plot(w, abs(h));
axis([-5, 5, 0, 2]);
grid on;

subplot(2, 1, 2);
plot(w, deg2rad(angle(h)));
axis([-5, 5, -0.05, 0.05]);
grid on;

figure(2);
subplot(2, 2, [1, 2]);
impulse(b, a);
xlabel('t'), ylabel('幅度');
title('单位冲激响应');
grid on;

t = 0 : 0.01 : 5;
f = exp(-2 .* t) .* heaviside(t);
subplot(2, 2, 3);
plot(t, f);
xlabel('t'), ylabel('f(t)');
axis([0, 3, 0, 1.2]);
title('输入信号');
grid on;

y = lsim(b, a, f ,t);
subplot(2, 2, 4);
plot(t, y);
xlabel('t'), ylabel('幅度');
title('零状态响应');
axis([0, 3, -1, 0.5]);
grid on;

