%% 3

a = [1, 5];
b = [1, 5, 6];
t = 0:0.01:10;
h = impulse(a, b, t);
subplot(2, 2, 1);
plot(t, h);
axis([0, 10, 0, 1.1]);
title('单位冲激响应');
grid on;

syms s t;
H = (s+5)/(s^2+5*s+6);
F = laplace(heaviside(t));
Y = H*F;
y = ilaplace(Y);
subplot(2, 2, 2);
fplot(y*heaviside(t));
axis([0, 10, 0, 0.9]);
title('单位阶跃响应');
grid on;

f = exp(-t)*heaviside(t);
Fs = laplace(f);
Ys = H*Fs;
yts = ilaplace(Ys);
subplot(2, 2, [3, 4]);
fplot(yts*heaviside(t));
axis([0, 10, 0, 0.4]);
title('零状态响应');
grid on;

