/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.common;

import edu.zju.common.FileHandler;
import edu.zju.common.ZipUtil;
import edu.zju.file.LogFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CExecutor {
    private String resultInf;
    private String erroInf;
    private String scriptPath = CExecutor.getTerminalDirectoy() + CExecutor.getFileSeparator() + ".script.sh";
    private static String currentDirectory;
    private static long processStartTime;

    public void execute(String command) {
        this.writeCommandIntoScript(command);
        this.executeCommand();
        new FileHandler().deleteFile(this.scriptPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeCommand() {
        try {
            Process ps = null;
            Runtime.getRuntime().exec("chmod 711 " + this.scriptPath);
            ps = Runtime.getRuntime().exec(this.scriptPath);
            StreamGobbler errorGobbler = new StreamGobbler(ps.getErrorStream(), "ERROR");
            StreamGobbler outGobbler = new StreamGobbler(ps.getInputStream(), "STDOUT");
            errorGobbler.start();
            outGobbler.start();
            int status = ps.waitFor();
            if (status == 0) return;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CExecutor.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        catch (IOException ex) {
            this.executeCommand();
        }
    }

    private void writeCommandIntoScript(String command) {
        try {
            FileHandler fileHandler = new FileHandler();
            fileHandler.writeFile(this.scriptPath);
            fileHandler.bw.write(command);
            fileHandler.bw.flush();
            fileHandler.bw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CExecutor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean isSucceed() {
        return this.getErroInformation().isEmpty();
    }

    public String getErroInformation() {
        return this.erroInf;
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getTerminalDirectoy() {
        if (currentDirectory == null) {
            File directory = new File("");
            currentDirectory = directory.getAbsolutePath();
        }
        return currentDirectory;
    }

    public String getGIPSDirectoy() {
        String path = new ZipUtil().getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        path = path.replace("file:", "").replace("/build/classes/", "");
        path = path.replace("/GIPS.jar", "");
        return path;
    }

    public static String getRunningTime() {
        if (processStartTime == 0L) {
            processStartTime = System.currentTimeMillis();
            CExecutor.println("\nJob start time: " + CExecutor.getCurrentTime());
        }
        return new String(new SimpleDateFormat("HH:mm:ss.SS").format(System.currentTimeMillis() - processStartTime - 28800000L) + "\t");
    }

    public static String getCurrentTime() {
        return new String(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(System.currentTimeMillis()));
    }

    public static void stopProgram(String info) {
        CExecutor.println(CExecutor.getRunningTime() + info + "\n");
        System.exit(1);
    }

    public static void println(String content) {
        System.out.println(content);
        LogFile log = new LogFile(new CExecutor().getGIPSDirectoy() + System.getProperty("file.separator") + "log.gips");
        log.write(content + "\n");
    }

    public static void print(String content) {
        System.out.print(content);
        LogFile log = new LogFile(new CExecutor().getGIPSDirectoy() + System.getProperty("file.separator") + "log.gips");
        log.write(content);
    }

    static {
        processStartTime = 0L;
    }

    private class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuffer sb = new StringBuffer();
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                isr = new InputStreamReader(this.is);
                br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                if (this.type.equals("ERROR")) {
                    CExecutor.this.erroInf = sb.toString().trim();
                }
                if (this.type.equals("STDOUT")) {
                    CExecutor.this.resultInf = sb.toString().trim();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    br.close();
                    isr.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(CExecutor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

