/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.common;

import edu.zju.common.CExecutor;
import edu.zju.file.Config;
import edu.zju.options.Init;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeoutException;

public class HttpFileDownloader {
    private String path;
    private int threadCount = Integer.parseInt(Config.getItem("THREADS").trim());
    private int runningThread = Integer.parseInt(Config.getItem("THREADS").trim());
    private String localPath;
    private static int reconnectionTime = 0;

    public void download(String fileUrl, String localFilePath) throws Exception {
        this.path = fileUrl;
        this.localPath = localFilePath;
        URL url = new URL(this.path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("GET");
        ++reconnectionTime;
        int code = 0;
        try {
            code = conn.getResponseCode();
        }
        catch (Exception e) {
            if (reconnectionTime == 5) {
                CExecutor.stopProgram("Connect error: Faile to donwload file " + this.path + "\nIf necessary, you can donwload  by yourself. Then read GIPS usage to set project configuration");
            }
            this.download(fileUrl, localFilePath);
        }
        if (code == 200) {
            int threadId;
            int length = conn.getContentLength();
            RandomAccessFile raf = new RandomAccessFile(this.localPath, "rwd");
            raf.setLength(length);
            raf.close();
            int blockSize = length / this.threadCount;
            Thread[] threads = new Thread[this.threadCount];
            for (threadId = 1; threadId <= this.threadCount; ++threadId) {
                int startIndex = (threadId - 1) * blockSize;
                int endIndex = threadId * blockSize - 1;
                if (threadId == this.threadCount) {
                    endIndex = length;
                }
                threads[threadId - 1] = new DownLoadThread(this.path, threadId, startIndex, endIndex, this.localPath);
                threads[threadId - 1].start();
            }
            for (threadId = 0; threadId < this.threadCount; ++threadId) {
                threads[threadId].join();
            }
        } else {
            CExecutor.stopProgram("Connect error: Faile to donwload file " + this.path + "\nIf necessary, you can donwload  by yourself. Then read GIPS usage to set project configuration");
        }
    }

    private class DownLoadThread
    extends Thread {
        private int threadId;
        private int startIndex;
        private int endIndex;
        private String localFilePath;
        private String recordFilePrefix;

        public DownLoadThread(String path, int threadId, int startIndex, int endIndex, String localFilePath) {
            this.threadId = threadId;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.localFilePath = localFilePath;
            this.recordFilePrefix = Init.getProjectDirectory() + CExecutor.getFileSeparator() + "." + localFilePath.split(CExecutor.getFileSeparator())[localFilePath.split(CExecutor.getFileSeparator()).length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    File tmp_file = new File(this.recordFilePrefix + this.threadId + ".txt");
                    if (tmp_file.exists() && tmp_file.length() > 0L) {
                        int downloadInt;
                        FileInputStream fio = new FileInputStream(tmp_file);
                        byte[] temp = new byte[1024];
                        int len = fio.read(temp);
                        String downloadlen = new String(temp, 0, len);
                        this.startIndex = downloadInt = Integer.parseInt(downloadlen);
                        fio.close();
                    }
                    URL url = new URL(HttpFileDownloader.this.path);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(5000);
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Range", "bytes=" + this.startIndex + "-" + this.endIndex);
                    int code = conn.getResponseCode();
                    InputStream is = conn.getInputStream();
                    RandomAccessFile raf = new RandomAccessFile(this.localFilePath, "rwd");
                    raf.seek(this.startIndex);
                    boolean isOver = false;
                    int len = 0;
                    byte[] buffer = new byte[1024];
                    int total = this.startIndex;
                    long currentTime = System.currentTimeMillis();
                    while (true) {
                        if (is.available() == 0) {
                            if (System.currentTimeMillis() - currentTime <= 10000L) continue;
                            currentTime = System.currentTimeMillis();
                            if (total < this.endIndex) break;
                            isOver = true;
                            break;
                        }
                        currentTime = System.currentTimeMillis();
                        len = is.read(buffer);
                        RandomAccessFile file = new RandomAccessFile(this.recordFilePrefix + this.threadId + ".txt", "rwd");
                        raf.write(buffer, 0, len);
                        file.write(("" + (total += len)).getBytes());
                        file.close();
                    }
                    is.close();
                    raf.close();
                    if (!isOver) {
                        throw new TimeoutException();
                    }
                    HttpFileDownloader.this.runningThread--;
                }
                catch (Exception e) {
                    this.run();
                }
                finally {
                    if (HttpFileDownloader.this.runningThread != 0) break block10;
                    for (int i = 1; i <= HttpFileDownloader.this.threadCount; ++i) {
                        File file = new File(this.recordFilePrefix + i + ".txt");
                        file.delete();
                    }
                }
            }
        }
    }
}

