/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.file;

import edu.zju.common.CExecutor;
import edu.zju.file.CommonInputFile;
import java.io.File;
import java.util.HashMap;

public class Config {
    public static final String path = new CExecutor().getGIPSDirectoy() + System.getProperty("file.separator") + "config";
    private static final CommonInputFile inputFile = new CommonInputFile(path);

    public static String getItem(String item) {
        String line;
        if (!new File(path).isFile()) {
            CExecutor.stopProgram("Error: Do not find config file in /path/to/GIPS_folder/");
        }
        if (!inputFile.isFile()) {
            CExecutor.stopProgram("GIPS config file can't find. Please check whether GIPS.jar and config are in the same directory");
        }
        while ((line = inputFile.readLine()) != null) {
            if (line.startsWith("#") || !line.trim().startsWith(item)) continue;
            inputFile.closeInput();
            return line.split(":")[1].toString().trim();
        }
        inputFile.closeInput();
        CExecutor.println("Do not find " + item + " in config");
        return null;
    }

    public static HashMap<String, Integer> getMatrix(String matrixName) {
        String line;
        HashMap<String, Integer> matrix = new HashMap<String, Integer>();
        while ((line = inputFile.readLine()) != null) {
            if (!line.trim().equals("@ " + matrixName)) continue;
            boolean flag = true;
            String[] aminoAcids = null;
            while ((line = inputFile.readLine()).trim().length() != 0 && line.toCharArray()[0] != '@') {
                if (line.toCharArray()[0] == '#') continue;
                line = line.replace("       ", "\t");
                line = line.replace("      ", "\t");
                line = line.replace("     ", "\t");
                line = line.replace("    ", "\t");
                line = line.replace("   ", "\t");
                line = line.replace("  ", "\t");
                line = line.replace(" ", "\t");
                if (flag) {
                    aminoAcids = line.split("\t");
                    flag = false;
                    continue;
                }
                String[] lineSplit = line.split("\t");
                for (int i = 1; i < lineSplit.length; ++i) {
                    String tempAA = aminoAcids[i] + lineSplit[0];
                    int score = Integer.parseInt(lineSplit[i].trim().toString());
                    matrix.put(tempAA, score);
                }
            }
            break block0;
        }
        if (matrix.size() == 0) {
            matrix = null;
            CExecutor.stopProgram("Don't find " + matrixName);
        }
        inputFile.closeInput();
        return matrix;
    }
}

