/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.filter;

import edu.zju.filter.FilterSuper;
import edu.zju.parameter.SampleParameter;
import edu.zju.parameter.SampleParameterBag;
import edu.zju.variant.SNP;
import edu.zju.variant.SampleVariant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class AncestryReferenceFilter
extends FilterSuper {
    private HashMap<String, Double> backgroundMutationRateBeforeFilter;
    private boolean isRemoveAllSnpInSamePosition = false;
    private int effectiveRegionLength = 0;
    private HashMap<String, HashSet<Integer>> studyPosition2Filter;

    public AncestryReferenceFilter(String filterStrategy, int effectiveRegionLegth) {
        super(filterStrategy);
        this.effectiveRegionLength = effectiveRegionLegth;
    }

    @Override
    public SampleParameterBag filterSampleVariantsInParameterBag(SampleParameterBag sampleParameterBag) {
        HashSet<String> sampleNames = new HashSet<String>(sampleParameterBag.getSamplesNamesList());
        HashSet<String> usedSampleNames = new HashSet<String>();
        for (String sampleNameOuter : sampleNames) {
            usedSampleNames.add(sampleNameOuter);
            if (sampleNames.size() == usedSampleNames.size()) break;
            SampleVariant sampleVariant = sampleParameterBag.getSample(sampleNameOuter).getSampleVariant();
            for (SNP snp : sampleVariant.getSnps()) {
                String chr = snp.getChr();
                int position = snp.getPosition();
                LinkedList<SampleVariant> sampleVariantsList = new LinkedList<SampleVariant>();
                sampleVariantsList.add(sampleVariant);
                for (String sampleNameInner : sampleNames) {
                    if (usedSampleNames.contains(sampleNameInner)) continue;
                    sampleVariantsList.add(sampleParameterBag.getSample(sampleNameInner).getSampleVariant());
                }
                LinkedList<SNP> snpInSamePosition = this.searchForSNPInSamePosition(chr, position, sampleVariantsList);
                if (!this.isRemoveSNP(snpInSamePosition)) continue;
                sampleParameterBag.removeSNPInSamePosition(chr, position);
                for (SNP snp2Remove : snpInSamePosition) {
                    sampleParameterBag.getSample(snp2Remove.getSampleName()).addStudyPositionToFilter(snp2Remove.getChr(), snp2Remove.getPosition());
                }
            }
        }
        return sampleParameterBag;
    }

    @Override
    SampleVariant filtrateSampleVariant(SampleVariant sampleVariant) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean isRemoveSNP(LinkedList<SNP> snps) {
        if (snps.size() <= 1) {
            return false;
        }
        if (!this.isRemoveAllSnpInSamePosition && snps.size() == 2) {
            HashSet<String> altSet = new HashSet<String>();
            String minimumLengthAlt = "NNNNN";
            for (SNP snp : snps) {
                String alt = snp.getAlt();
                if (alt.length() < minimumLengthAlt.length()) {
                    minimumLengthAlt = alt;
                }
                altSet.add(snp.getAlt());
            }
            if (minimumLengthAlt.length() >= 5) {
                return true;
            }
            if (altSet.size() == 2) {
                return false;
            }
        }
        return true;
    }

    private LinkedList<SNP> searchForSNPInSamePosition(String chr, int position, LinkedList<SampleVariant> sampleVariants) {
        LinkedList<SNP> snps = new LinkedList<SNP>();
        for (SampleVariant sampleVariant : sampleVariants) {
            if (!sampleVariant.isSNP(chr, position)) continue;
            snps.add(sampleVariant.get1SNP(chr, position));
        }
        return snps;
    }

    @Override
    SampleParameter filtrateSampleParameter(SampleParameter sampleParameter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

