/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.artificial;

import edu.zju.common.CExecutor;
import edu.zju.common.LineHandler;
import edu.zju.common.RunnablePrinter;
import edu.zju.file.CommonInputFile;
import edu.zju.file.CommonOutputFile;
import edu.zju.file.Config;
import edu.zju.file.FileFactory;
import edu.zju.genome.artificial.ArtificialReadGenerator;
import edu.zju.genome.artificial.SampleArtificialChromosome;
import edu.zju.genome.artificial.SampleArtificialGenome;
import edu.zju.parameter.GlobalParameter;
import edu.zju.parameter.SampleParameterBag;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArtificialSequenceReadsFileGenerator {
    private CommonInputFile sampleSequenceReadsFile;
    private SampleArtificialGenome sampleArtificialGenome;
    private int readsNumber = 0;

    public ArtificialSequenceReadsFileGenerator(CommonInputFile sampleSequenceReadsFile, SampleArtificialGenome sampleArtificialGenome) {
        this.setSampleSequenceReadsFilePath(sampleSequenceReadsFile);
        this.setSampleArtificialGenome(sampleArtificialGenome);
    }

    private void setSampleSequenceReadsFilePath(CommonInputFile file) {
        if (!file.isFile()) {
            CExecutor.stopProgram(file.getFilePath() + " does not exist!");
        }
        this.sampleSequenceReadsFile = file;
    }

    private void setSampleArtificialGenome(SampleArtificialGenome genome) {
        this.sampleArtificialGenome = genome;
    }

    private CommonInputFile getSampleSequenceReadsFile() {
        return this.sampleSequenceReadsFile;
    }

    private SampleArtificialGenome getSampleArtificialGenome() {
        return this.sampleArtificialGenome;
    }

    public CommonInputFile generate() {
        int i;
        CommonOutputFile outputFile;
        CommonInputFile inputFile;
        String path;
        block10: {
            String chrID;
            path = SampleParameterBag.getIntermediateFilePath() + System.getProperty("file.separator") + this.sampleArtificialGenome.getSampleName() + System.getProperty("file.separator") + Config.getItem("SIM_READS_FILE");
            inputFile = this.getSampleSequenceReadsFile();
            outputFile = FileFactory.getOutputFile(path);
            String line = null;
            while ((line = inputFile.readLine()).toCharArray()[0] == '@' || line.split("\t").length <= 3) {
                outputFile.write(line + '\n');
            }
            LineHandler lh = new LineHandler();
            lh.splitByTab(line);
            try {
                chrID = lh.linesplit[2];
                if (chrID.equals("*")) {
                }
            }
            catch (NumberFormatException e) {}
            break block10;
            if (!chrID.equals("ChrUn") && !chrID.equals("ChrSy")) {
                SampleArtificialChromosome sampleArtificialChromosome = this.getSampleArtificialGenome().getSampleArtificialChromosome(chrID);
                ArtificialReadGenerator artificialReadGenerator = new ArtificialReadGenerator(sampleArtificialChromosome, line);
                line = artificialReadGenerator.getNewRead();
                if (line != null) {
                    outputFile.write(line + '\n');
                }
                this.addReadsNumber(1);
            }
        }
        CExecutor.print(CExecutor.getRunningTime() + "Reading " + inputFile.getFilePath() + ". Please wait");
        RunnablePrinter printer = new RunnablePrinter();
        printer.setContent2Print("*");
        printer.setWelcomeWords("");
        printer.setSleepSecond(150);
        Thread printerThread = new Thread(printer);
        printerThread.start();
        int threadNumber = GlobalParameter.getThreadsNumber();
        Thread[] thread = new Thread[threadNumber];
        for (i = 0; i < threadNumber; ++i) {
            thread[i] = new Thread(new RunnableArtificialReadsGenerator(inputFile, outputFile));
            thread[i].start();
        }
        for (i = 0; i < threadNumber; ++i) {
            try {
                thread[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ArtificialSequenceReadsFileGenerator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        outputFile.closeOutput();
        inputFile.closeInput();
        printerThread.stop();
        CExecutor.println("");
        printerThread.interrupt();
        CommonInputFile samFile = FileFactory.getInputFile(path, "SAM");
        CExecutor.println("\n" + CExecutor.getRunningTime() + "SAM format file: " + samFile.getFilePath());
        CExecutor.println(CExecutor.getRunningTime() + "Reads number for simulated SNPs: " + this.getReadsNumber());
        return samFile;
    }

    private synchronized void addReadsNumber(int number) {
        this.readsNumber += number;
    }

    private int getReadsNumber() {
        return this.readsNumber;
    }

    private class RunnableArtificialReadsGenerator
    implements Runnable {
        private CommonInputFile input;
        private CommonOutputFile output;

        public RunnableArtificialReadsGenerator(CommonInputFile input, CommonOutputFile output) {
            this.input = input;
            this.output = output;
        }

        @Override
        public void run() {
            String line = null;
            int readsNumber = 0;
            LineHandler lh = new LineHandler();
            while ((line = this.input.readLine()) != null) {
                SampleArtificialChromosome sampleArtificialChromosome;
                ArtificialReadGenerator artificialReadGenerator;
                lh.splitByTab(line);
                String chrID = lh.linesplit[2].toString();
                if (chrID.equals("*") || chrID.equals("ChrUn") || chrID.equals("ChrSy") || (line = (artificialReadGenerator = new ArtificialReadGenerator(sampleArtificialChromosome = ArtificialSequenceReadsFileGenerator.this.getSampleArtificialGenome().getSampleArtificialChromosome(chrID), line)).getNewRead()) == null) continue;
                this.output.write(line + '\n');
                ++readsNumber;
            }
            ArtificialSequenceReadsFileGenerator.this.addReadsNumber(readsNumber);
        }
    }
}

