/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.gffGenome;

import edu.zju.common.LineHandler;
import edu.zju.genome.gffGenome.Gene;
import edu.zju.genome.gffGenome.Transcript;
import edu.zju.genome.gffGenome.TranscriptModule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public class Chromosome
extends edu.zju.genome.abstractGenome.Chromosome {
    private HashMap<String, Gene> genes = new HashMap();
    private HashMap<String, String> transcriptIDInGene = new HashMap();
    private HashSet<String> parentIdSet = new HashSet();
    private int length = 0;

    public Chromosome(String chrID, LinkedList<String> chromosomeInformation) {
        super(chrID);
        this.setChromosome(chromosomeInformation);
    }

    private void setChromosome(LinkedList<String> chromosomeInformation) {
        String feature = null;
        String id = null;
        LineHandler lh = new LineHandler();
        String geneIDTemp = null;
        for (String line : chromosomeInformation) {
            TranscriptModule transcriptModule;
            if (line.trim().isEmpty()) continue;
            lh.splitByTab(line);
            HashMap<String, String> tagValuePaire = new HashMap<String, String>();
            for (String temp : lh.linesplit[8].split(";")) {
                String[] paire = temp.split("=");
                if (paire.length < 2) {
                    tagValuePaire.put(paire[0], "");
                    continue;
                }
                tagValuePaire.put(paire[0].trim(), paire[1].trim());
            }
            id = (String)tagValuePaire.get("ID");
            feature = lh.linesplit[2];
            int startPosition = Integer.parseInt(lh.linesplit[3]);
            int endPosition = Integer.parseInt(lh.linesplit[4]);
            if (feature.equals("gene")) {
                String geneName = (String)tagValuePaire.get("Name");
                String strand = lh.linesplit[6];
                Gene gene = new Gene(id, geneName, this.getID(), strand, startPosition, endPosition);
                this.addGene(gene);
                Transcript transcript = new Transcript(id, "transcript", id, startPosition, endPosition);
                this.addTranscript(transcript);
                geneIDTemp = id;
                continue;
            }
            String parent = lh.regexMatch(lh.linesplit[8], "Parent=(.*?)(;|$)");
            if (parent == null) {
                parent = geneIDTemp;
            }
            if (this.parentIdSet.contains(parent)) {
                Transcript transcript = new Transcript(id, feature, parent, startPosition, endPosition);
                this.addTranscript(transcript);
            }
            if (this.addTranscriptModule(transcriptModule = new TranscriptModule(id, feature, parent, startPosition, endPosition))) continue;
            transcriptModule = new TranscriptModule(id, feature, geneIDTemp, startPosition, endPosition);
            this.addTranscriptModule(transcriptModule);
        }
        this.transcriptIDInGene = null;
        this.parentIdSet = null;
        chromosomeInformation.clear();
    }

    private void addGene(Gene gene) {
        this.genes.put(gene.getID(), gene);
    }

    public Gene getGene(String geneID) {
        return this.genes.get(geneID);
    }

    public LinkedList<Gene> getGenes() {
        LinkedList<Gene> genes = new LinkedList<Gene>(this.genes.values());
        return genes;
    }

    public Set<String> getGeneIDs() {
        return new TreeSet<String>(this.genes.keySet());
    }

    private void addTranscript(Transcript transcript) {
        this.transcriptIDInGene.put(transcript.getID(), transcript.getParent());
        this.parentIdSet.add(transcript.getParent());
        Gene gene = this.getGene(transcript.getParent());
        gene.addTranscript(transcript);
        this.renewGene(gene);
    }

    private void renewGene(Gene gene) {
        this.genes.put(gene.getID(), gene);
    }

    private String getGeneIDAccordingToRNAID(String rnaId) {
        return this.transcriptIDInGene.get(rnaId);
    }

    private boolean addTranscriptModule(TranscriptModule transcriptModule) {
        Gene gene = this.getGene(this.getGeneIDAccordingToRNAID(transcriptModule.getParent()));
        if (gene == null) {
            return false;
        }
        gene.addTranscriptModule(transcriptModule);
        this.renewGene(gene);
        return true;
    }
}

