/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.gips;

import edu.zju.gips.SampleGene;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class CandidateGeneBag {
    private LinkedList<SampleGene> candidateGenes = new LinkedList();
    private int candidateGeneNumber = 0;
    private int anticipation;

    public CandidateGeneBag(int anticipation) {
    }

    public void addCandidateGene(SampleGene candidateGene) {
        this.candidateGenes.add(candidateGene);
        ++this.candidateGeneNumber;
    }

    public LinkedList<SampleGene> getCandidateGenes() {
        LinkedList list = new LinkedList();
        Collections.sort(this.candidateGenes, new Comparator<SampleGene>(){

            @Override
            public int compare(SampleGene s1, SampleGene s2) {
                int value = 0;
                if (s1.getSignificanceRegardlessOfAnticipation() < s2.getSignificanceRegardlessOfAnticipation()) {
                    value = -1;
                } else if (s1.getSignificanceRegardlessOfAnticipation() == s2.getSignificanceRegardlessOfAnticipation()) {
                    value = 0;
                } else if (s1.getSignificanceRegardlessOfAnticipation() > s2.getSignificanceRegardlessOfAnticipation()) {
                    value = 1;
                }
                return value;
            }
        });
        return this.candidateGenes;
    }

    private void setAnticipation(int anticipation) {
        this.anticipation = anticipation;
    }

    public int getCandidateGeneNumber() {
        return this.candidateGeneNumber;
    }
}

