/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.gips;

import edu.zju.common.NumeralHandler;
import edu.zju.gips.SampleGene;
import java.util.LinkedList;

public class SampleGeneBag {
    private int anticipation;
    private double expectedGeneNumberInGenome = 0.0;
    private LinkedList<SampleGene> genes = new LinkedList();
    private int sampleGeneNumber = 0;

    public SampleGeneBag(int anticipation) {
        this.setAnticipation(anticipation);
    }

    public SampleGeneBag() {
    }

    public void addGene(SampleGene geneToBeSelected) {
        this.genes.add(geneToBeSelected);
        ++this.sampleGeneNumber;
    }

    public double getSignificance(String geneID) {
        for (SampleGene sampleGeneToBeSelected : this.genes) {
            if (!sampleGeneToBeSelected.getID().equals(geneID)) continue;
            return sampleGeneToBeSelected.getSignificanceRegardlessOfAnticipation();
        }
        return -1.0;
    }

    public void setAnticipation(int anticipation) {
        this.anticipation = anticipation;
    }

    public int getAnticipation() {
        return this.anticipation;
    }

    private void addGeneExpectionNumber(double geneSignificance) {
        this.expectedGeneNumberInGenome += geneSignificance;
    }

    public double getRandomGeneDiscoveryNumberInGenome() {
        for (SampleGene sampleGene : this.genes) {
            this.expectedGeneNumberInGenome += sampleGene.getRandomGeneDiscoveryNumberAtAnticipation();
        }
        return NumeralHandler.setScale(this.expectedGeneNumberInGenome);
    }

    LinkedList<SampleGene> getSampleGenes() {
        return this.genes;
    }

    int getSampleGeneNumber() {
        return this.sampleGeneNumber;
    }
}

