/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.gips;

import edu.zju.gips.SampleGene;
import java.math.BigDecimal;
import java.util.Iterator;

public class SignificanceCaculator {
    private double[][] tempPool;
    private int sampleNumber;
    private int anticipation;
    private Iterator<SampleGene> sampleGeneIterator;

    public SignificanceCaculator(int sampleNumber) {
        this.setSampleNumber(sampleNumber);
    }

    public SignificanceCaculator(int sampleNumber, Iterator<SampleGene> iterator) {
        this.sampleGeneIterator = iterator;
        this.setSampleNumber(sampleNumber);
    }

    public double calculateGenesSignificance(int anticipation, double[] backgroundMutationRate, int geneEffectiveRegionLength) {
        int i;
        double[][] geneMutationRate = new double[this.sampleNumber][2];
        for (i = 0; i < this.sampleNumber; ++i) {
            geneMutationRate[i][1] = Math.pow(1.0 - backgroundMutationRate[i], geneEffectiveRegionLength);
            geneMutationRate[i][0] = 1.0 - geneMutationRate[i][1];
        }
        this.tempPool = new double[this.sampleNumber + 1][this.sampleNumber + 1];
        for (i = 0; i < this.sampleNumber + 1; ++i) {
            for (int j = 0; j < this.sampleNumber + 1; ++j) {
                this.tempPool[i][j] = -1.0;
            }
        }
        double probability = 0.0;
        for (int i2 = this.sampleNumber; i2 >= anticipation; --i2) {
            probability = this.caculateAtSpecificAnticipation(i2, this.sampleNumber, geneMutationRate) + probability;
        }
        return probability;
    }

    public double calculateTrueTargetGeneDiscoveriedProbability(int anticipation, double[] detectingRate) {
        int i;
        double[][] detectingProbability = new double[this.sampleNumber][2];
        for (i = 0; i < this.sampleNumber; ++i) {
            detectingProbability[i][0] = detectingRate[i];
            detectingProbability[i][1] = 1.0 - detectingRate[i];
        }
        this.tempPool = new double[this.sampleNumber + 1][this.sampleNumber + 1];
        for (i = 0; i < this.sampleNumber + 1; ++i) {
            for (int j = 0; j < this.sampleNumber + 1; ++j) {
                this.tempPool[i][j] = -1.0;
            }
        }
        double probability = 0.0;
        for (int i2 = this.sampleNumber; i2 >= anticipation; --i2) {
            this.setAnticipation(i2);
            probability = this.caculateAtSpecificAnticipation(this.anticipation, this.sampleNumber, detectingProbability) + probability;
        }
        return probability;
    }

    public double calculate1Phenotype1GeneValidation(int number, double[] detectingRate) {
        int i;
        if (number == this.sampleNumber) {
            return 1.0;
        }
        double[][] detectingProbability = new double[this.sampleNumber][2];
        for (i = 0; i < this.sampleNumber; ++i) {
            detectingProbability[i][0] = detectingRate[i];
            detectingProbability[i][1] = 1.0 - detectingRate[i];
        }
        this.tempPool = new double[this.sampleNumber + 1][this.sampleNumber + 1];
        for (i = 0; i < this.sampleNumber + 1; ++i) {
            for (int j = 0; j < this.sampleNumber + 1; ++j) {
                this.tempPool[i][j] = -1.0;
            }
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        for (int i2 = number; i2 >= 0; --i2) {
            this.setAnticipation(i2);
            bigDecimal = bigDecimal.add(new BigDecimal(this.caculateAtSpecificAnticipation(this.anticipation, this.sampleNumber, detectingProbability)));
        }
        return bigDecimal.doubleValue();
    }

    private double caculateAtSpecificAnticipation(int anticipation, int sampleNumber, double[][] geneMutationRate) {
        double calculate_result = 1.0;
        if (this.tempPool[anticipation][sampleNumber] != -1.0) {
            calculate_result = this.tempPool[anticipation][sampleNumber];
            return calculate_result;
        }
        if (anticipation == sampleNumber) {
            for (int i = this.sampleNumber - sampleNumber; i < this.sampleNumber; ++i) {
                calculate_result *= geneMutationRate[i][0];
            }
            this.tempPool[anticipation][sampleNumber] = calculate_result;
            return calculate_result;
        }
        if (anticipation == 0 && sampleNumber > 0) {
            for (int i = this.sampleNumber - sampleNumber; i < this.sampleNumber; ++i) {
                calculate_result *= geneMutationRate[i][1];
            }
            this.tempPool[anticipation][sampleNumber] = calculate_result;
            return calculate_result;
        }
        this.tempPool[anticipation][sampleNumber] = calculate_result = geneMutationRate[this.sampleNumber - sampleNumber][0] * this.caculateAtSpecificAnticipation(anticipation - 1, sampleNumber - 1, geneMutationRate) + geneMutationRate[this.sampleNumber - sampleNumber][1] * this.caculateAtSpecificAnticipation(anticipation, sampleNumber - 1, geneMutationRate);
        return calculate_result;
    }

    void setAnticipation(int i) {
        this.anticipation = i;
    }

    private void setSampleNumber(int number) {
        this.sampleNumber = number;
    }

    private int getSampleNumber() {
        return this.sampleNumber;
    }
}

