/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.options;

import edu.zju.common.CExecutor;
import edu.zju.common.ZipUtil;
import edu.zju.file.CommonOutputFile;
import edu.zju.file.Config;
import edu.zju.file.FileFactory;
import edu.zju.options.Init;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TESTProject {
    public void initiateTestProject(String projectString) throws FileNotFoundException, IOException {
        int len;
        if (projectString == null || projectString.trim().isEmpty()) {
            CExecutor.stopProgram("Please set Test project's path");
        }
        if (new File(projectString + CExecutor.getFileSeparator() + "Test").exists()) {
            CExecutor.stopProgram("Project Test already exist");
        }
        InputStream in = this.getClass().getResourceAsStream(Config.getItem("Test.Project"));
        String zipPath = CExecutor.getTerminalDirectoy() + CExecutor.getFileSeparator() + "Test.zip";
        FileOutputStream out = new FileOutputStream(zipPath);
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, len);
        }
        in.close();
        out.flush();
        ((OutputStream)out).close();
        new ZipUtil().unzipFiles(new File(zipPath), projectString);
        new File(zipPath).delete();
        projectString = projectString + CExecutor.getFileSeparator() + "Test";
        new Init(projectString);
        this.generateIniFile();
        this.generateCallerScriptFile();
    }

    private void generateIniFile() {
        CommonOutputFile iniOutFile = FileFactory.getOutputFile(Init.getParameterFilePath());
        String s = CExecutor.getFileSeparator();
        iniOutFile.write("[GLOBAL]\nPROJECT        : Test\nREF_GENOME_ANNOTATION.GFF: " + Init.getRefDirectory() + s + "Test.gff3" + "\nSNPEFF_GENOME_VERSION    : Test" + "\nSNPEFF :                     #/path/to/snpefffolder" + "\nVAR_CALL_SCRIPT:" + Init.getScriptDirectory() + s + "samtools_Q13q30_script" + "\nEFF_REGION   : CDS|SpliceSite=2" + "\nVAR_FILTERS  : BA" + "\nSCORE_MATRIX : DEFAULT" + "\nCANDIDATE_CRITERION :" + "\nNUM_SIM_SNPS : 800 " + "\n\n[SAMPLE_LIST]\nsample1\nsample2\nsample3" + "\n\n[SAMPLE]\nSAMPLE_NAME :sample1\nSAMPLE.VCF :" + Init.getDataDirectory() + s + "sample1" + s + "sample1.vcf\nREADS_ALIGNMENT.SAM :" + Init.getDataDirectory() + s + "sample1" + s + "sample1.sam" + "\n\n[SAMPLE]\nSAMPLE_NAME :sample2\nSAMPLE.VCF :" + Init.getDataDirectory() + s + "sample2" + s + "sample2.vcf\nREADS_ALIGNMENT.SAM :" + Init.getDataDirectory() + s + "sample2" + s + "sample2.sam" + "\n\n[SAMPLE]\nSAMPLE_NAME :sample3\nSAMPLE.VCF :" + Init.getDataDirectory() + s + "sample3" + s + "sample3.vcf\nREADS_ALIGNMENT.SAM :" + Init.getDataDirectory() + s + "sample3" + s + "sample3.sam" + "\n\n\n");
        String note = "######################################################\n# Test project has been initiated. \n# Please make sure SAMtools script (samtools, bcftools, vcfutils.pl) is already in your computer environment, or use absolute script path\n# Samtools is avalible in Samtools.sourceforge.net\n# Please make sure path of SNPEFF folder has been set in " + Init.getParameterFilePath() + "\n# SnpEff is avalible in snpeff.sourceforge.net" + "\n# Detail information to configure before GIPS running, see Test/README file." + "\n######################################################";
        CExecutor.println(note);
        iniOutFile.write(note);
        iniOutFile.closeOutput();
    }

    private void generateCallerScriptFile() {
        String s = CExecutor.getFileSeparator();
        CommonOutputFile scriptOutFile = FileFactory.getOutputFile(Init.getScriptDirectory() + s + "samtools_Q13q30_script");
        String note = "\n######################################################\n# Author: Zhongxu Zhu\n# Script Requirement:\n# Two command line variables required while script running: \"$1\" is SAM format input file, \"$2\" VCF format output file\n# GIPS will create a 'temporary' directory in working folder, so intermediate files while running script are recommended to dump into 'temporary'\n######################################################";
        scriptOutFile.write(note + "\n\n");
        scriptOutFile.write("# please set the absolute path of samtools and bcftools. No blank space in the following two lines. \n samtools=\n bcftools=# change .sam file to .bam file\n $samtools view -bS \"$1\" > " + Init.getTemporaryFolderPath() + s + "sample.bam" + "\n# sort" + "\n $samtools sort " + Init.getTemporaryFolderPath() + s + "sample.bam " + Init.getTemporaryFolderPath() + s + "sample.sort" + "\n# index" + "\n $samtools index " + Init.getTemporaryFolderPath() + s + "sample.sort.bam" + "\n# call" + "\n $samtools mpileup -ugf " + Init.getRefDirectory() + s + "Test.fa " + Init.getTemporaryFolderPath() + s + "sample.sort.bam" + " -Q 13 -q 30 -go - | $bcftools call -vmO v -o \"$2\"" + "");
        scriptOutFile.closeOutput();
    }

    private void generateReadMeFile() {
    }
}

