/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.parameter;

import edu.zju.common.CExecutor;
import edu.zju.common.LineHandler;

public class EffectiveRegionParameter {
    private int promoterLength = 100;
    private int spliceSite = 2;
    private boolean consider5UTR = false;
    private boolean consider3UTR = false;
    private boolean considerCDS = true;
    private boolean considerExon = false;
    private static String effectiveRegionPara = null;

    public EffectiveRegionParameter(String parameter) {
        LineHandler lh = new LineHandler();
        lh.splitByVerticalLine(parameter);
        this.promoterLength = 0;
        this.spliceSite = 0;
        this.consider3UTR = false;
        this.consider5UTR = false;
        this.considerCDS = false;
        this.considerExon = false;
        try {
            for (int i = 0; i < lh.linesplit.length; ++i) {
                String temp = lh.linesplit[i].toLowerCase();
                if (temp.contains("promoter")) {
                    this.setPromoterLength(Integer.parseInt(temp.split("=")[1]));
                    continue;
                }
                if (temp.equals("cds")) {
                    this.setConsiderCDS(true);
                    continue;
                }
                if (temp.equals("exon")) {
                    this.setConsiderExon(true);
                    continue;
                }
                if (temp.contains("splicesite")) {
                    try {
                        this.setSpliceSite(Integer.parseInt(temp.split("=")[1]));
                    }
                    catch (Exception e) {
                        this.setSpliceSite(2);
                    }
                    continue;
                }
                if (temp.equals("5utr")) {
                    this.setConsider5UTR(true);
                    continue;
                }
                if (temp.equals("3utr")) {
                    this.setConsider3UTR(true);
                    continue;
                }
                CExecutor.stopProgram("Don't find region: " + temp);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CExecutor.stopProgram("region parameter is not set correctly or empty! ");
        }
        catch (NumberFormatException e1) {
            CExecutor.stopProgram("Please input an integer, for example Promoter=150,SpliceSite=2");
        }
        this.printRegionParameter();
    }

    private void setPromoterLength(int length) {
        if (length < 0) {
            length = 200;
            CExecutor.println("Promoter length is not correct and has been set 200! ");
        }
        this.promoterLength = length;
    }

    private void setSpliceSite(int length) {
        if (length < 0 || length > 3) {
            length = 2;
            CExecutor.println("splice site is not correct and has been set 2! ");
        }
        this.spliceSite = length;
    }

    private void setConsider5UTR(boolean consider5UTR) {
        this.consider5UTR = consider5UTR;
    }

    private void setConsider3UTR(boolean consider3UTR) {
        this.consider3UTR = consider3UTR;
    }

    private void setConsiderCDS(boolean considerCDS) {
        this.considerCDS = considerCDS;
    }

    private void setConsiderExon(boolean considerExon) {
        this.considerExon = considerExon;
    }

    public void printRegionParameter() {
        CExecutor.println("\t\t   Promoter length: " + this.getPromoterLength());
        CExecutor.println("\t\t   Splice site: " + this.getSpliceSite());
        CExecutor.println("\t\t   5UTR: " + this.isConsider5UTR());
        CExecutor.println("\t\t   3UTR: " + this.isConsider3UTR());
        CExecutor.println("\t\t   CDS: " + this.isConsiderCDS());
        CExecutor.println("\t\t   Exon: " + this.isConsiderExon());
        effectiveRegionPara = "Promoter length(" + this.getPromoterLength() + "); Splice site(" + this.getSpliceSite() + "); 5'UTR(" + this.isConsider5UTR() + "); 3'UTR(" + this.isConsider3UTR() + "); EXON(" + this.isConsiderExon() + "); CDS(" + this.isConsiderCDS() + ")";
    }

    public int getPromoterLength() {
        return this.promoterLength;
    }

    public int getSpliceSite() {
        return this.spliceSite;
    }

    public boolean isConsider5UTR() {
        return this.consider5UTR;
    }

    public boolean isConsider3UTR() {
        return this.consider3UTR;
    }

    public boolean isConsiderCDS() {
        return this.considerCDS;
    }

    public boolean isConsiderExon() {
        return this.considerExon;
    }

    public static String getEffectiveRegionParamString() {
        return effectiveRegionPara;
    }
}

