/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.parameter;

import edu.zju.common.CExecutor;
import edu.zju.common.LineHandler;
import edu.zju.file.CommonInputFile;
import edu.zju.file.FileFactory;
import edu.zju.filter.AncestryReferenceFilter;
import edu.zju.filter.BigDifferenceFilter;
import edu.zju.filter.CongestionFilter;
import edu.zju.filter.ControlFilter;
import edu.zju.filter.EffectiveRegionFilter;
import edu.zju.filter.FilterSuper;
import edu.zju.genome.effectiveRegion.GenomeEffectiveRegion;
import edu.zju.genome.gffGenome.Genome;
import edu.zju.parameter.EffectiveRegionParameter;
import edu.zju.parameter.GlobalParameter;
import java.util.LinkedList;

public class FilterParameter {
    private LinkedList<String> filterStrategy = new LinkedList();
    private GenomeEffectiveRegion genomeEffectiveRegion;
    private boolean isNeedEffectiveRegion = true;
    private Genome genome;
    private String genomeName;
    private EffectiveRegionParameter regionParameter;
    private boolean isNeedEffectiveRegionParameter = true;
    private int snpDensity = 10;
    private CommonInputFile variantControl = null;
    private int controlFilterMode = 0;

    public LinkedList<FilterSuper> getFilter() {
        LinkedList<FilterSuper> filters = new LinkedList<FilterSuper>();
        if (this.filterStrategy.contains("AncestryReference")) {
            filters.add(new AncestryReferenceFilter("AncestryReference", this.getGenomeEffectiveRegion().getLengt()));
        }
        if (this.filterStrategy.contains("EffectiveRegion")) {
            filters.add(new EffectiveRegionFilter(this.getGenomeEffectiveRegion(), "EffectiveRegion"));
        }
        if (this.filterStrategy.contains("BigDifference")) {
            filters.add(new BigDifferenceFilter("BigDifference"));
        }
        if (this.filterStrategy.contains("Congestion")) {
            filters.add(new CongestionFilter("Congestion"));
        }
        filters.add(new ControlFilter("Control", this.controlFilterMode));
        return filters;
    }

    public void setFilterStrategy(String info) {
        info = info.replace("|", "");
        info = info + "E";
        StringBuffer stringTemp = new StringBuffer();
        if (info.contains("A")) {
            stringTemp.append("A");
        }
        if (info.contains("C")) {
            stringTemp.append("C");
        }
        if (info.contains("E")) {
            stringTemp.append("E");
        }
        if (info.contains("B")) {
            stringTemp.append("B");
        }
        info = stringTemp.toString();
        this.isNeedEffectiveRegion = false;
        this.isNeedEffectiveRegionParameter = false;
        block12: for (int i = 0; i < info.toString().length(); ++i) {
            String filtrationStrategy;
            switch (filtrationStrategy = String.valueOf(info.toCharArray()[i]).toUpperCase().toString()) {
                case "E": {
                    if (this.filterStrategy.contains("EffectiveRegion")) continue block12;
                    this.filterStrategy.add("EffectiveRegion");
                    this.isNeedEffectiveRegionParameter = true;
                    this.isNeedEffectiveRegion = true;
                    continue block12;
                }
                case "A": {
                    if (this.filterStrategy.contains("AncestryReference")) continue block12;
                    this.filterStrategy.add("AncestryReference");
                    continue block12;
                }
                case "B": {
                    if (this.filterStrategy.contains("BigDifference")) continue block12;
                    this.filterStrategy.add("BigDifference");
                    continue block12;
                }
                case "C": {
                    if (this.filterStrategy.contains("Congestion")) continue block12;
                    this.filterStrategy.add("Congestion");
                    continue block12;
                }
                default: {
                    CExecutor.stopProgram("Don't find filter strategy: " + filtrationStrategy);
                }
            }
        }
        if (!this.filterStrategy.contains("EffectiveRegion") && GlobalParameter.getToolType().equals("gips")) {
            this.filterStrategy.add("EffectiveRegion");
            this.isNeedEffectiveRegionParameter = true;
            this.isNeedEffectiveRegion = true;
        }
        CExecutor.println(CExecutor.getRunningTime() + "Filter strategy: " + this.filterStrategy);
    }

    public void setGenomeEffectiveRegion(GenomeEffectiveRegion g) {
        this.genomeEffectiveRegion = g;
    }

    public LinkedList<String> getFilterStrategy() {
        return this.filterStrategy;
    }

    boolean isNeedEffectiveRegion() {
        return this.isNeedEffectiveRegion;
    }

    private String getGenomeName() {
        if (this.genomeName == null) {
            this.genomeName = GlobalParameter.getGenomeVersion();
        }
        return this.genomeName;
    }

    public GenomeEffectiveRegion getGenomeEffectiveRegion() {
        return this.genomeEffectiveRegion;
    }

    public boolean isNeedEffectiveRegionParameter() {
        return this.isNeedEffectiveRegionParameter;
    }

    public void setEffectiveRegionParameter(EffectiveRegionParameter effectiveRegionParameter) {
        this.regionParameter = effectiveRegionParameter;
    }

    public void setWindowDensity(int density) {
        this.snpDensity = density;
    }

    private int getWindowDensity() {
        return this.snpDensity;
    }

    private void setVariantControl(CommonInputFile variantControl) {
        this.variantControl = variantControl;
        this.filterStrategy.addFirst("Control");
        CExecutor.println("Control Filter: True");
    }

    public void setControlFilter(String line) {
        LineHandler lineHandler = new LineHandler();
        lineHandler.splitByComma(line);
        CommonInputFile control = FileFactory.getInputFile(lineHandler.linesplit[0], "VCF");
        this.setVariantControl(control);
        if (lineHandler.linesplit.length == 3) {
            CExecutor.stopProgram("-c /path/to/control.vcf");
        }
        if (lineHandler.linesplit.length == 2) {
            this.setControlFilterMode(Integer.valueOf(lineHandler.linesplit[1]));
        }
    }

    private void setControlFilterMode(int mode) {
        this.controlFilterMode = mode;
    }
}

