/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.parameter;

import edu.zju.common.CExecutor;
import edu.zju.common.StringSecurity;
import edu.zju.file.CommonInputFile;
import edu.zju.file.Config;
import edu.zju.options.Init;
import edu.zju.parameter.GlobalParameter;
import edu.zju.parameter.SampleParameter;
import edu.zju.parameter.SampleParameterBag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;

public class GIPSJob {
    private String jobType;
    private GlobalParameter globalParameter;
    private SampleParameterBag sampleParameterBag;
    private String md5;
    private boolean update = false;

    public void setJobType(String type) {
        this.jobType = type;
    }

    public void setGlobalParameter(GlobalParameter globalParameter) {
        this.globalParameter = globalParameter;
    }

    public void setSampleParameterBag(SampleParameterBag sampleParameterBag) throws IOException {
        this.sampleParameterBag = sampleParameterBag;
        if (this.update) {
            this.updateSampleForIterating(Init.getWorkingDirectroy() + CExecutor.getFileSeparator() + Config.getItem("RESULT_GIPS_FILE"));
            this.update = false;
        }
    }

    public GlobalParameter getGlobalParameter() {
        return this.globalParameter;
    }

    public SampleParameterBag getSampleParameterBag() {
        return this.sampleParameterBag;
    }

    public String getJobType() {
        if (this.jobType == null) {
            this.jobType = GlobalParameter.getToolType();
            return this.jobType;
        }
        return this.jobType;
    }

    public String getMD5() {
        if (this.md5 == null) {
            StringSecurity stringSecurity = new StringSecurity();
            this.md5 = stringSecurity.string2MD5(String.valueOf(this.sampleParameterBag) + String.valueOf(this.globalParameter) + CExecutor.getCurrentTime());
        }
        return this.md5;
    }

    private void updateSampleForIterating(String filePath) throws IOException {
        SampleParameter sampleParameter;
        String line;
        CommonInputFile gipsResultFile = new CommonInputFile(filePath);
        StringBuffer sb = new StringBuffer();
        block0: while ((line = gipsResultFile.readLine()) != null) {
            if (!line.contains("[GIPS TRACEBACK]")) continue;
            while ((line = gipsResultFile.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.contains("[END GIPS TRACEBACK]")) continue block0;
                sb.append(line + "\n");
            }
        }
        StringSecurity ss = new StringSecurity();
        String data = sb.toString();
        data = data.substring(0, data.length() - 1);
        data = ss.gunzip(data);
        StringReader sr = new StringReader(data);
        BufferedReader br = new BufferedReader(sr);
        SampleParameterBag sampleParameterBag = new SampleParameterBag();
        HashMap<String, String> itemMapInfo = new HashMap<String, String>();
        while ((line = br.readLine()) != null && ((line = line.trim()).startsWith("#") || line.trim().isEmpty() || !line.trim().contains("[SAMPLE]"))) {
        }
        String item = null;
        String info = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            if (!line.contains(":")) {
                if (!line.trim().contains("[SAMPLE]")) continue;
                sampleParameter = new SampleParameter(this.globalParameter, itemMapInfo);
                sampleParameterBag.addSampleParameter(sampleParameter);
                itemMapInfo = new HashMap();
                continue;
            }
            item = line.split(":")[0].trim();
            if (line.contains("#")) {
                line = line.split("#")[0].trim();
            }
            if (line.split(":").length != 2) continue;
            info = line.split(":")[1].trim();
            itemMapInfo.put(item, info);
        }
        sampleParameter = new SampleParameter(this.globalParameter, itemMapInfo);
        sampleParameterBag.addSampleParameter(sampleParameter);
        itemMapInfo = new HashMap();
        this.sampleParameterBag = this.updateParameterCheck(this.sampleParameterBag, sampleParameterBag);
    }

    private SampleParameterBag updateParameterCheck(SampleParameterBag current, SampleParameterBag traceback) {
        for (String sample : current.getSamplesNamesList()) {
            boolean b1 = true;
            boolean b2 = true;
            boolean b3 = true;
            SampleParameter s1 = current.getSample(sample);
            SampleParameter s2 = traceback.getSample(sample);
            try {
                b1 = s1.getVCFMd5().equals(s2.getVCFMd5());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                b2 = s1.getSAMMd5().equals(s2.getSAMMd5());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                b3 = s1.getScriptMd5().equals(s2.getScriptMd5());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!b1) {
                if (b2 && b3) {
                    CExecutor.stopProgram("\nError information: Variant call file (VCF) has been changed, VCF file should be coresponding to caller script or/and SAM format file.\n                        caller_script\n        SAM format file ---------------> VCF format file\nPlease provide a new caller script or/and SAM format file that different from before.\nThis information just for ***[" + sample + "]***");
                }
            } else if (!b2 || !b3) {
                CExecutor.stopProgram("\nError information: Variant call file (VCF) isn't changed, VCF file should be coresponding to caller script or/and SAM format file. But SAM format file or/and caller script changed.\n                        caller_script\n        SAM format file ---------------> VCF format file\nPlease provide a new caller script or/and SAM format file that different from before.\nThis information just for ***[" + sample + "]***");
            }
            if (!b1 || !b2 || !b3) continue;
            double currentvcs = 0.0;
            double tracebackvcs = 0.0;
            currentvcs = s1.getHomoVCSEstimated();
            tracebackvcs = s2.getHomoVCSEstimated();
            if (currentvcs == 0.0 && tracebackvcs != 0.0) {
                s1.setEstimatedHomoVCS(tracebackvcs);
            }
            currentvcs = 0.0;
            tracebackvcs = 0.0;
            currentvcs = s1.getHeteroVCSEstimated();
            tracebackvcs = s2.getHeteroVCSEstimated();
            if (currentvcs == 0.0 && tracebackvcs != 0.0) {
                s1.setEstimatedHeteroVCS(tracebackvcs);
            }
            current.updateSampleParameter(s1);
        }
        return current;
    }

    public void jobCheck() throws Exception {
        if (this.getJobType().equals("init") || this.getJobType().endsWith("Test")) {
            return;
        }
        if (GlobalParameter.getSNPEffPath() == null) {
            CExecutor.stopProgram("\nPlease set snpEff folder (not snpEff.jar) path, like: \nSNPEFF:/path/to/snpeff_folder\nSnpEff is available in snpeff.sourceforge.net. Download and unzip file, then set variable in " + Init.getParameterFilePath() + "\n");
        }
        if (GlobalParameter.getGenomeVersion() == null) {
            CExecutor.stopProgram("Please set a SnpEff supportive  genome version  in " + Init.getParameterFilePath() + "\nGenomes are listed in snpeff.sourceforge.net/download.html#dbs\n");
        }
        if (this.jobType.equals("gips") && new GlobalParameter().getLibraryGenomeGffFile() == null) {
            CExecutor.stopProgram("Please set LIB_GENOME_ANNOTATION.GFF\nFile is available in " + Config.getItem("H_SAPIENS.GFF") + "\nDownload and gunzip this file" + "\nIt is recommended for user to put this file into " + Init.getRefDirectory() + "\n");
        }
        if ((this.jobType.equals("vcs") || this.jobType.equals("gips")) && GlobalParameter.getSampleGffFile() == null) {
            CExecutor.stopProgram("Please set GFF file path for " + GlobalParameter.getGenomeVersion() + '\n');
        }
        GIPSJob gIPSJob = this;
        if (gIPSJob.sampleParameterBag.getSampleNumber() == 0) {
            CExecutor.stopProgram("No sample in " + Init.getParameterFilePath());
        }
        for (SampleParameter sampleParameter : this.sampleParameterBag.getBag()) {
            if (sampleParameter.getVCFFile() == null) {
                CExecutor.stopProgram("Please set SAMPLE.VCF variable in " + sampleParameter.getName() + " specific [SAMPLE] setion");
            }
            if (this.jobType.equals("filter")) continue;
            double s1 = sampleParameter.getHeteroVCSEstimated();
            double s2 = sampleParameter.getHomoVCSEstimated();
            if (s1 == 0.0 && s2 == 0.0) continue;
            if (sampleParameter.getSequenceReadsFile() == null) {
                CExecutor.stopProgram("Please set READS_ALIGNMENT.SAM variable in " + sampleParameter.getName() + " specific [SAMPLE] setion");
            }
            if (sampleParameter.getCallerScript() != null) continue;
            CExecutor.stopProgram("No caller script.\nPlease set VAR_CALL_SCRIPT variable in " + sampleParameter.getName() + " specific [SAMPLE] setion or in [GLOBAL]");
        }
    }

    public void setJobNeedUpdate() {
        this.update = true;
    }
}

