/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.parameter;

import edu.zju.common.CExecutor;
import edu.zju.common.NumeralHandler;
import edu.zju.file.CommonInputFile;
import edu.zju.file.Config;
import edu.zju.genome.effectiveRegion.GenomeEffectiveRegion;
import edu.zju.gips.CandidateGeneBag;
import edu.zju.gips.SampleGeneBag;
import edu.zju.options.Init;
import edu.zju.parameter.GlobalParameter;
import edu.zju.parameter.SampleParameter;
import edu.zju.variant.SampleVariant;
import edu.zju.variant.SampleVariantBag;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class SampleParameterBag {
    private String organism;
    private LinkedList<Map.Entry<String, SampleParameter>> bag;
    private static int sampleNum;
    private double homozygousGeneDetectingRate;
    private double heterozygousGeneDetectingRate;
    private SampleGeneBag sampleGeneBag;
    private CandidateGeneBag candidateGeneBag;
    private double validation1Phenotype1GeneHeterozygousGene;
    private double validation1Phenotype1GeneHomozygousGene;
    private int[] maxNumberOfStudySubjectsHarboringMuationInSameGene = new int[2];
    private static String intermediateFilePath;
    private LinkedList<String> sampleNamesList;
    private boolean isContainSampleSpecified = false;

    public SampleParameterBag() {
        this.bag = new LinkedList();
        intermediateFilePath = Init.getWorkingDirectroy() + System.getProperty("file.separator") + Config.getItem("IntermediateFile");
        File file = new File(intermediateFilePath);
        if (!file.exists()) {
            file.mkdir();
            CExecutor.println("temporary folder is created");
        }
    }

    private void setOrganism(String name) {
        this.organism = name;
    }

    private String getOrganism() {
        return this.organism;
    }

    public static void setSampleNumber(int sampleNumber) {
        sampleNum = sampleNumber;
    }

    public static int getSampleNumber() {
        return sampleNum;
    }

    public void updateSampleParameter(SampleParameter sampleParameter) {
        for (Map.Entry entry : this.bag) {
            if (!((String)entry.getKey()).equals(sampleParameter.getName())) continue;
            entry.setValue(sampleParameter);
            break;
        }
    }

    public SampleParameter getSample(String sampleName) {
        for (Map.Entry entry : this.bag) {
            if (!sampleName.equals(entry.getKey())) continue;
            return (SampleParameter)entry.getValue();
        }
        CExecutor.stopProgram("Do not find sample: [" + sampleName + "]. If your are using update mode, please make sure your have not changed \"[SAMPLE_LIST]\" section.");
        return null;
    }

    public void setSampleGeneBag(SampleGeneBag sampleGeneBag1) {
        this.sampleGeneBag = sampleGeneBag1;
    }

    public void setCandidateGeneBag(CandidateGeneBag candidateGeneBag1) {
        this.candidateGeneBag = candidateGeneBag1;
    }

    public int getAnticipation() {
        int anticipation = GlobalParameter.getAnticipation();
        return anticipation;
    }

    public HashMap<String, Double> getSampleHomozygousVariantDetectionSensitivity() {
        HashMap<String, Double> sensitivity = new HashMap<String, Double>();
        for (String sampleName : this.getSamplesNamesList()) {
            sensitivity.put(sampleName, this.getSample(sampleName).getHomoVariantDetectionSensitivity());
        }
        return sensitivity;
    }

    public HashMap<String, Double> getSampleHeterozygousVariantDetectionSensitivity() {
        HashMap<String, Double> sensitivity = new HashMap<String, Double>();
        for (String sampleName : this.getSamplesNamesList()) {
            sensitivity.put(sampleName, this.getSample(sampleName).getHeteroVariantDetectionSensitivity());
        }
        return sensitivity;
    }

    public LinkedList<Map.Entry<String, CommonInputFile>> getSamplesVariantFile() {
        LinkedList<Map.Entry<String, CommonInputFile>> fileList = new LinkedList<Map.Entry<String, CommonInputFile>>();
        HashMap<String, CommonInputFile> fileTemp = new HashMap<String, CommonInputFile>();
        for (String sampleName : this.getSamplesNamesList()) {
            fileTemp = new HashMap();
            fileTemp.put(sampleName, this.getSample(sampleName).getVCFFile());
            if (!fileTemp.entrySet().iterator().hasNext()) continue;
            fileList.add(fileTemp.entrySet().iterator().next());
        }
        return fileList;
    }

    public HashMap<String, CommonInputFile> getSamplesSequenceReadsFiles() {
        HashMap<String, CommonInputFile> files = new HashMap<String, CommonInputFile>();
        for (String sampleName : this.getSamplesNamesList()) {
            files.put(sampleName, this.getSample(sampleName).getSequenceReadsFile());
        }
        return files;
    }

    public void setHomozygousGeneDetectingRate(double rate) {
        rate = this.homozygousGeneDetectingRate = NumeralHandler.setScale(rate);
        CExecutor.println(CExecutor.getRunningTime() + "If phenotype is recessive:\n" + "Chance to report true phenotype-associated genes: " + rate);
    }

    public double getHomozygousGeneDetectingRate() {
        return this.homozygousGeneDetectingRate;
    }

    public double getHetrozygousGeneDetectingRate() {
        return this.heterozygousGeneDetectingRate;
    }

    public void setHeterozygousGeneDetectingRate(double rate) {
        rate = this.heterozygousGeneDetectingRate = NumeralHandler.setScale(rate);
        CExecutor.println(CExecutor.getRunningTime() + "If phenotype is  dominant:\n" + "Chance to report true phenotype-associated genes: " + rate);
    }

    public void set1Phenoty1GeneValidationHeterozygousGene(double validation) {
        validation = this.validation1Phenotype1GeneHeterozygousGene = NumeralHandler.setScale(validation);
        CExecutor.println("Significance of voilating Mendelian phenotype assumption: " + validation);
    }

    public double get1Phenotype1GeneValidationHomozygous() {
        return this.validation1Phenotype1GeneHomozygousGene;
    }

    public double get1Phenotype1GeneValidationHeterozygous() {
        return this.validation1Phenotype1GeneHeterozygousGene;
    }

    public void set1Phenoty1GeneValidationHomozygousGene(double validation) {
        validation = this.validation1Phenotype1GeneHomozygousGene = NumeralHandler.setScale(validation);
        CExecutor.println("Significance of voilating Mendelian phenotype assumption: " + validation);
    }

    private void setMaxSampleNumberHarboringMutationInSameGene(int[] number) {
        this.maxNumberOfStudySubjectsHarboringMuationInSameGene = number;
    }

    public void addSampleParameter(SampleParameter sampleParameter) {
        if (sampleParameter.isSpecified() && !sampleParameter.isPassSpecify()) {
            CExecutor.stopProgram("[" + sampleParameter.getName() + "] SPECIFY_BVF, SPECIFY_HOMO_VDS and SPECIFY_HETERO_VDS parameters should be specified together");
        }
        if (sampleParameter.isSpecified() && sampleParameter.isPassSpecify()) {
            this.setContainSpecifiedSample();
        }
        HashMap<String, SampleParameter> map = new HashMap<String, SampleParameter>();
        map.put(sampleParameter.getName(), sampleParameter);
        for (Map.Entry entry : map.entrySet()) {
            this.bag.add(entry);
        }
    }

    public static String getIntermediateFilePath() {
        return intermediateFilePath;
    }

    public void printSNPNumberInSample() {
        Iterator sampleNameIterator = this.getSamplesNamesList().iterator();
        while (sampleNameIterator.hasNext()) {
            SampleVariant sampleVariant = this.getSample((String)sampleNameIterator.next()).getSampleVariant();
            CExecutor.println("\t\t" + sampleVariant.getName() + "\t" + String.valueOf(sampleVariant.getSNPCounts()));
        }
    }

    public HashSet<SampleParameter> getBag() {
        HashSet<SampleParameter> set = new HashSet<SampleParameter>();
        for (Map.Entry entry : this.bag) {
            set.add((SampleParameter)entry.getValue());
        }
        return set;
    }

    public HashMap<String, Integer> getSNPNumberInSample() {
        HashMap<String, Integer> snpNumber = new HashMap<String, Integer>();
        for (String sampleName : this.getSamplesNamesList()) {
            int number = this.getSample(sampleName).getSampleVariant().getSNPCounts();
            snpNumber.put(sampleName, number);
        }
        return snpNumber;
    }

    public void removeSNPInSamePosition(String chr, int position) {
        if (chr.equals("ChrSy") || chr.equals("ChrUn")) {
            return;
        }
        Iterator sampleNameIterator = this.getSamplesNamesList().iterator();
        while (sampleNameIterator.hasNext()) {
            SampleParameter sampleParameter = this.getSample((String)sampleNameIterator.next());
            SampleVariant sampleVariant = sampleParameter.getSampleVariant();
            sampleVariant.removeSNP(chr, position);
            sampleParameter.setSampleVariant(sampleVariant);
            this.updateSampleParameter(sampleParameter);
        }
    }

    public void estimateStudyFir(GenomeEffectiveRegion genomeEffectiveRegion) {
        for (SampleParameter sampleParameter : this.getBag()) {
            sampleParameter.estimateStudyFir(genomeEffectiveRegion);
            this.updateSampleParameter(sampleParameter);
        }
    }

    public CandidateGeneBag getCandidateGeneBag() {
        return this.candidateGeneBag;
    }

    public void setSampleVariant(SampleVariantBag sampleVariantBag) {
        for (String sampleName : this.getSamplesNamesList()) {
            SampleParameter sampleParameter = this.getSample(sampleName);
            sampleParameter.setSampleVariant(sampleVariantBag.getSampleVariant(sampleName));
            this.updateSampleParameter(sampleParameter);
        }
    }

    public void setSampleNamesList(LinkedList<String> list) {
        this.sampleNamesList = list;
    }

    public LinkedList<String> getSamplesNamesList() {
        return this.sampleNamesList;
    }

    public SampleGeneBag getSampleGeneBag() {
        return this.sampleGeneBag;
    }

    public String dumpDataForTracing() {
        StringBuffer sb = new StringBuffer();
        sb.append("[SAMPLE_LIST]\n");
        for (String sampleName : this.getSamplesNamesList()) {
            sb.append(sampleName + "\n");
        }
        for (String sampleName : this.getSamplesNamesList()) {
            SampleParameter sampleParameter = this.getSample(sampleName);
            sb.append("\n[SAMPLE]");
            sb.append("\nSAMPLE_NAME:" + sampleParameter.getName());
            try {
                sb.append("\nSAMPLE.VCF:" + sampleParameter.getVCFFile().getFilePath());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                sb.append("\nREADS_ALIGNMENT.SAM:" + sampleParameter.getSequenceReadsFile().getFilePath());
            }
            catch (Exception e) {
                // empty catch block
            }
            sb.append("\nVAR_CALL_SCRIPT:" + sampleParameter.getCallerScript());
            sb.append("\nSCORE_MATRIX:" + sampleParameter.getMatrix());
            try {
                sb.append("\nCONTROL:" + sampleParameter.getControlFile().getFilePath());
            }
            catch (Exception e) {
                // empty catch block
            }
            sb.append("\nSCRIPT_MD5:" + sampleParameter.getScriptMd5());
            sb.append("\nVCF_MD5:" + sampleParameter.getVCFMd5());
            sb.append("\nSAM_MD5:" + sampleParameter.getSAMMd5());
            sb.append("\nNUM_SIM_SNPS:" + sampleParameter.getArtificialSNPNumber());
            sb.append("\nMAX_VAR_DENSITY:" + sampleParameter.getSNPDensity());
            sb.append("\nESTIMATED_BVF:" + sampleParameter.getBackgroundMutationRateEstimated());
            sb.append("\nESTIMATED_HOMO_VDS:" + sampleParameter.getHomoVariantDetectionSensitivityEstimated());
            sb.append("\nESTIMATED_HETERO_VDS:" + sampleParameter.getHeteroVariantDetectionSensitivityEstimated());
            sb.append("\nESTIMATED_HOMO_VCS:" + sampleParameter.getHomoVCSEstimated());
            sb.append("\nESTIMATED_HETERO_VCS:" + sampleParameter.getHeteroVCSEstimated());
        }
        return sb.toString();
    }

    public boolean isContainSpecifiedSample() {
        return this.isContainSampleSpecified;
    }

    private void setContainSpecifiedSample() {
        this.isContainSampleSpecified = true;
    }
}

