/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.variant;

import edu.zju.file.CommonInputFile;
import edu.zju.variant.SNP;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class SampleVariant {
    private String name;
    private HashMap<String, LinkedList<SNP>> snps = new HashMap();
    private int snpCountsBeforeFiltering;
    private int snpCounts;
    private CommonInputFile vcfFilePath;
    private HashMap<String, Integer> snpGenotypeCount;
    private LinkedList<String> chrSequenceName = new LinkedList();

    public SampleVariant(String sampleName) {
        this.setName(sampleName);
        this.snpCounts = 0;
        this.snpCountsBeforeFiltering = 0;
        this.snpGenotypeCount = new HashMap<String, Integer>(){
            {
                this.put("0/1", 0);
                this.put("1/1", 0);
                this.put("1/2", 0);
            }
        };
    }

    public void setVCFFile(CommonInputFile path) {
        this.vcfFilePath = path;
    }

    public CommonInputFile getVCFFile() {
        return this.vcfFilePath;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void addChrNameInSequence(String chrName) {
        this.chrSequenceName.add(chrName.toString());
    }

    public LinkedList<String> getChrNameInSequence() {
        return this.chrSequenceName;
    }

    public void addSNP(SNP snp) {
        if (snp.getChr() != null && snp != null && !snp.getChr().equals("ChrSy") && !snp.getChr().equals("ChrUn")) {
            LinkedList<Object> snpsInChr;
            String chr = snp.getChr();
            if (this.snps.keySet().contains(chr)) {
                snpsInChr = this.snps.get(chr);
                snpsInChr.add(snp);
            } else {
                snpsInChr = new LinkedList<SNP>();
                snpsInChr.add(snp);
                this.addChrNameInSequence(chr);
            }
            this.snps.put(chr, snpsInChr);
            if (this.snpCounts == this.snpCountsBeforeFiltering) {
                this.snpCountsBeforeFiltering = this.snpCounts = this.getSNPCounts() + 1;
            } else {
                this.snpCounts = this.getSNPCounts() + 1;
            }
        }
    }

    public LinkedList<SNP> getSnps() {
        LinkedList<SNP> listSNP = new LinkedList<SNP>();
        for (String chrName : this.getChrNameInSequence()) {
            listSNP.addAll((Collection<SNP>)this.snps.get(chrName));
        }
        return listSNP;
    }

    public int getSNPCounts() {
        return this.snpCounts;
    }

    public int getSNPCountsBeforeFiltering() {
        return this.snpCountsBeforeFiltering;
    }

    public void removeSNP(String chr, int pos) {
        boolean flag = false;
        LinkedList<SNP> listSNPInChr = this.get1ChrSNP(chr);
        Iterator iterator = listSNPInChr.iterator();
        while (iterator.hasNext()) {
            if (((SNP)iterator.next()).getPosition() != pos) continue;
            iterator.remove();
            flag = true;
            break;
        }
        if (flag) {
            this.snps.put(chr, listSNPInChr);
            this.snpCounts = this.getSNPCounts() - 1;
        }
    }

    public SNP get1SNP(String chr, int pos) {
        LinkedList<SNP> listSNPInChr = this.get1ChrSNP(chr);
        for (SNP snp : listSNPInChr) {
            if (snp.getPosition() != pos) continue;
            return snp;
        }
        return null;
    }

    public boolean isSNP(String chr, int position) {
        if (this.snpCounts == 0) {
            return false;
        }
        for (SNP snp : this.get1ChrSNP(chr)) {
            if (!snp.getChr().equals(chr) || snp.getPosition() != position) continue;
            return true;
        }
        return false;
    }

    private LinkedList<SNP> get1ChrSNP(String chr) {
        LinkedList<SNP> list = this.snps.get(chr);
        if (list == null) {
            list = new LinkedList();
        }
        return list;
    }

    public void renewSNPsInVariant(LinkedList<SNP> list) {
        this.snps = new HashMap();
        this.chrSequenceName = new LinkedList();
        this.snpCounts = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addSNP((SNP)iterator.next());
        }
    }

    public LinkedList<SNP> get1ChromosomeSNPs(String chr) {
        return this.snps.get(chr);
    }
}

