/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.variant;

import edu.zju.common.CExecutor;
import edu.zju.variant.SampleVariant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class SampleVariantBag {
    private HashMap<String, SampleVariant> bag = new HashMap();
    private int sampleNum = 0;

    public boolean isReady() {
        return this.sampleNum != 0;
    }

    public Set<String> getSampleNames() {
        return new TreeSet<String>(this.bag.keySet());
    }

    public void addSampleVariant(SampleVariant sampleVariant) {
        this.bag.put(sampleVariant.getName(), sampleVariant);
        ++this.sampleNum;
        CExecutor.println(CExecutor.getRunningTime() + "\t" + sampleVariant.getName() + "\t" + sampleVariant.getSNPCounts() + " variants");
    }

    public HashSet<SampleVariant> getsampleVariantBag() {
        HashSet<SampleVariant> samplesVariant = new HashSet<SampleVariant>();
        Iterator<String> iterator = this.getSampleNames().iterator();
        while (iterator.hasNext()) {
            samplesVariant.add(this.bag.get(iterator.next()));
        }
        return samplesVariant;
    }

    public SampleVariant getSampleVariant(String name) {
        if (!this.bag.containsKey(name)) {
            CExecutor.println("No" + name + "'s variant ");
            return null;
        }
        return this.bag.get(name);
    }

    public void renewSampleVariant(SampleVariant sampleVariant) {
        String name = sampleVariant.getName();
        if (this.bag.keySet().contains(name)) {
            this.bag.put(name, sampleVariant);
        } else {
            CExecutor.println("Could not renew sample varaice----" + name);
        }
    }

    public void removeSNPInSamePosition(String chr, int position) {
        if (chr.equals("ChrSy") || chr.equals("ChrUn")) {
            return;
        }
        Iterator<String> sampleNameIterator = this.getSampleNames().iterator();
        while (sampleNameIterator.hasNext()) {
            SampleVariant sampleVariant = this.getSampleVariant(sampleNameIterator.next());
            sampleVariant.removeSNP(chr, position);
            this.renewSampleVariant(sampleVariant);
        }
    }

    public void printSNPNumberInSample() {
        Iterator<String> sampleNameIterator = this.getSampleNames().iterator();
        while (sampleNameIterator.hasNext()) {
            SampleVariant sampleVariant = this.getSampleVariant(sampleNameIterator.next());
            CExecutor.println(sampleVariant.getName() + "\t" + String.valueOf(sampleVariant.getSNPCounts()));
        }
    }

    public HashMap<String, Integer> getSNPNumberInSample() {
        HashMap<String, Integer> snpNumber = new HashMap<String, Integer>();
        for (String sampleName : this.getSampleNames()) {
            int number = this.getSampleVariant(sampleName).getSNPCounts();
            snpNumber.put(sampleName, number);
        }
        return snpNumber;
    }

    public int getSampleNumber() {
        return this.sampleNum;
    }
}

