/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.common;

import edu.zju.common.CExecutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileHandler {
    public BufferedReader br;
    public BufferedWriter bw;
    public String[] files;

    public void readFile(String filepath) {
        try {
            this.br = new BufferedReader(new FileReader(filepath));
        }
        catch (FileNotFoundException ex) {
            CExecutor.println(filepath + " doesn't exit or path is not correct ");
        }
    }

    public void writeFile(String filepath) {
        try {
            this.bw = new BufferedWriter(new FileWriter(new File(filepath)));
        }
        catch (IOException ex) {
            Logger.getLogger(FileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeNewLine() {
        try {
            this.bw.write(10);
        }
        catch (IOException ex) {
            Logger.getLogger(FileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeLineSplitting() {
        try {
            this.bw.write("    -----    ------    \n");
        }
        catch (IOException ex) {
            Logger.getLogger(FileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void appendToFile(String filePath) {
        try {
            this.bw = new BufferedWriter(new FileWriter(new File(filePath), true));
        }
        catch (IOException ex) {
            Logger.getLogger(FileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void getAllFile(String folderpath) {
        File f = new File(folderpath);
        String[] temp = null;
        temp = f.list();
        int j = 0;
        ArrayList<String> list = new ArrayList<String>();
        try {
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i].toCharArray()[0] == '.' || temp[i].toCharArray()[temp[i].length() - 1] == '~') continue;
                list.add(folderpath + '/' + temp[i]);
                ++j;
            }
        }
        catch (NullPointerException e) {
            CExecutor.println("\u6587\u4ef6\u5939\u4e2d\u6ca1\u6709\u6587\u4ef6");
        }
        this.files = new String[j];
        Iterator iterator = list.iterator();
        iterator.hasNext();
        for (int i = 0; i < j; ++i) {
            this.files[i] = iterator.next().toString();
        }
    }

    public void deleteFile(String filePath) {
        File file = new File(filePath);
        file.delete();
    }

    public void createFile(String pathName) {
        try {
            new File(pathName).createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(FileHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChannelCopy(File input, File output) {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            fi = new FileInputStream(input);
            fo = new FileOutputStream(output);
            in = fi.getChannel();
            out = fo.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fi.close();
                in.close();
                fo.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

