/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.common;

import edu.zju.common.CExecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipUtil {
    public void unzipFiles(File zipFile, String descDir) throws ZipException, IOException {
        File targetFolder;
        if (descDir.endsWith(CExecutor.getFileSeparator())) {
            descDir = descDir.substring(0, descDir.length() - 1);
        }
        if (!(targetFolder = new File(descDir)).exists()) {
            targetFolder.mkdirs();
        }
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String targetPath = descDir + CExecutor.getFileSeparator() + entryName;
            File targetFile = new File(targetPath);
            if (targetFile.getName().startsWith(".") || targetFile.getPath().contains("__MACOSX")) continue;
            if (entry.isDirectory()) {
                targetFile.mkdirs();
                continue;
            }
            if (!new File(targetFile.getParent()).exists()) {
                new File(targetFile.getParent()).mkdirs();
            }
            FileOutputStream out = new FileOutputStream(targetFile);
            byte[] buffer = new byte[1024];
            InputStream in = zip.getInputStream(entry);
            while ((len = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            in.close();
            out.flush();
            ((OutputStream)out).close();
        }
    }
}

