/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.file;

import edu.zju.common.CExecutor;
import edu.zju.file.CommonInputFile;

public class GFF
extends CommonInputFile {
    public GFF(String path) {
        super(path);
    }

    @Override
    protected void check() {
        String line;
        super.check();
        if (!this.getFileName().toLowerCase().endsWith(".gff3") && !this.getFileName().toLowerCase().endsWith("gff")) {
            CExecutor.stopProgram(this.getFileName() + " should end with .gff3. Please make sure GFF file version (version3 required).");
        }
        boolean isHasIDField = false;
        int checkLines = 1000;
        while ((line = this.readLine()) != null && checkLines != 0) {
            if (line.trim().length() == 0 || line.startsWith("#") || !line.split("\t")[8].contains("ID")) continue;
            isHasIDField = true;
            --checkLines;
        }
        this.closeInput();
        if (!isHasIDField) {
            CExecutor.stopProgram("GFF file does not contain ID information");
        }
    }
}

