/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.filter;

import edu.zju.common.CExecutor;
import edu.zju.filter.FilterSuper;
import edu.zju.matrix.AAChange;
import edu.zju.matrix.Matrix;
import edu.zju.parameter.SampleParameter;
import edu.zju.variant.SNP;
import edu.zju.variant.SNPAnnotation;
import edu.zju.variant.SampleVariant;
import java.util.Iterator;
import java.util.LinkedList;

public class BigDifferenceFilter
extends FilterSuper {
    private String matrixName;
    private Matrix matrix;
    private int maxAAsimilarityScore;

    public BigDifferenceFilter(String strategy) {
        super(strategy);
    }

    private void setMatrix(String matrixName) {
        CExecutor.println("\t\tMatrix: " + matrixName);
        this.matrixName = matrixName;
        this.matrix = new Matrix(this.matrixName);
    }

    private void setMaxAASimilarityScore(int score) {
        this.maxAAsimilarityScore = score;
    }

    @Override
    SampleVariant filtrateSampleVariant(SampleVariant sampleVariant) {
        LinkedList<SNP> sampleSNPs = sampleVariant.getSnps();
        LinkedList<SNP> filtratedSNPs = new LinkedList<SNP>();
        boolean i = false;
        for (SNP snp : sampleSNPs) {
            if (snp.isIndel()) {
                filtratedSNPs.add(snp);
                continue;
            }
            LinkedList<SNPAnnotation> snpAnnotation = snp.getSNPAnnotations();
            int originAnnotationNumber = snpAnnotation.size();
            Iterator iterator = snpAnnotation.iterator();
            while (iterator.hasNext()) {
                String mutationCodon;
                AAChange codonChange;
                String originCodon;
                int score;
                SNPAnnotation annotation = (SNPAnnotation)iterator.next();
                if (annotation.isPassBigDfferenceFilter() || annotation.isHighRisk() || !annotation.isCoding() || (score = this.matrix.getScore(originCodon = (codonChange = annotation.getCodonChange()).getOriginAA(), mutationCodon = codonChange.getMutationAA())) <= this.maxAAsimilarityScore) continue;
                iterator.remove();
            }
            int finalAnnotationNumber = snpAnnotation.size();
            if (originAnnotationNumber != 0 && finalAnnotationNumber <= 0) continue;
            filtratedSNPs.add(snp);
        }
        sampleVariant.renewSNPsInVariant(filtratedSNPs);
        return sampleVariant;
    }

    @Override
    SampleParameter filtrateSampleParameter(SampleParameter sampleParameter) {
        this.setMatrix(sampleParameter.getMatrix());
        this.setMaxAASimilarityScore(sampleParameter.getMaxAASimilarityScore());
        SampleVariant sampleVariant = sampleParameter.getSampleVariant();
        sampleVariant = this.filtrateSampleVariant(sampleVariant);
        sampleParameter.setSampleVariant(sampleVariant);
        return sampleParameter;
    }
}

