/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.filter;

import edu.zju.common.CExecutor;
import edu.zju.filter.FilterSuper;
import edu.zju.genome.effectiveRegion.GeneEffectiveRegion;
import edu.zju.genome.effectiveRegion.GenomeEffectiveRegion;
import edu.zju.parameter.EffectiveRegionParameter;
import edu.zju.parameter.SampleParameter;
import edu.zju.variant.SNP;
import edu.zju.variant.SNPAnnotation;
import edu.zju.variant.SampleVariant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class EffectiveRegionFilter
extends FilterSuper {
    private GenomeEffectiveRegion genomeEffectiveRegion;

    public EffectiveRegionFilter(GenomeEffectiveRegion genomeEffectiveRegion, String strategy) {
        super(strategy);
        this.setGenomeEffectiveRegion(genomeEffectiveRegion);
    }

    private void setGenomeEffectiveRegion(GenomeEffectiveRegion genomeEffectiveRegion1) {
        this.genomeEffectiveRegion = genomeEffectiveRegion1;
    }

    @Override
    SampleVariant filtrateSampleVariant(SampleVariant sampleVariant) {
        LinkedList<SNP> sampleSNPs = sampleVariant.getSnps();
        LinkedList<SNP> filtratedSNPs = new LinkedList<SNP>();
        if (EffectiveRegionParameter.getEffectiveRegionParamString().contains("EXON(false)")) {
            boolean isRemoveCDS = false;
            if (EffectiveRegionParameter.getEffectiveRegionParamString().contains("CDS(false)")) {
                isRemoveCDS = true;
            }
            for (SNP snptemp : sampleSNPs) {
                Iterator annotationIterator = snptemp.getSNPAnnotations().iterator();
                while (annotationIterator.hasNext()) {
                    SNPAnnotation annotation = (SNPAnnotation)annotationIterator.next();
                    if (annotation.isExon()) {
                        annotationIterator.remove();
                        continue;
                    }
                    if (!isRemoveCDS || !annotation.isCoding()) continue;
                    annotationIterator.remove();
                }
            }
        }
        for (SNP snp : sampleSNPs) {
            String chr = snp.getChr();
            int pos = snp.getPosition();
            boolean isRetained = false;
            HashSet<String> geneNameSet = new HashSet<String>();
            if (snp.getSNPAnnotations().size() == 0 && this.genomeEffectiveRegion.isInEffectiveRegion(chr, pos)) {
                isRetained = true;
            }
            for (SNPAnnotation snpa : snp.getSNPAnnotations()) {
                String geneName = snpa.getItsGeneName();
                if (geneName == null || geneName.trim().length() == 0) {
                    if (!this.genomeEffectiveRegion.isInEffectiveRegion(chr, pos)) continue;
                    isRetained = true;
                    continue;
                }
                if ((geneName = geneName.trim()).length() == 0) continue;
                geneNameSet.add(geneName);
            }
            for (String name : geneNameSet) {
                GeneEffectiveRegion geneEffectiveRegion = null;
                try {
                    geneEffectiveRegion = this.genomeEffectiveRegion.getChromosomeEffectiveRegion(chr).get1GeneEffectiveRegionByGeneName(name);
                }
                catch (Exception e) {
                    CExecutor.stopProgram("\nDo not find chromosome " + chr + " in GFF3 file");
                }
                if (geneEffectiveRegion == null && this.genomeEffectiveRegion.isInEffectiveRegion(chr, pos)) {
                    isRetained = true;
                    break;
                }
                if (geneEffectiveRegion == null || !geneEffectiveRegion.isInGeneEffectiveRegion(pos)) continue;
                isRetained = true;
                break;
            }
            Iterator iterator = snp.getSNPAnnotations().iterator();
            while (iterator.hasNext()) {
                SNPAnnotation snpa;
                snpa = (SNPAnnotation)iterator.next();
                if (!snpa.isPassBigDfferenceFilter()) continue;
                iterator.remove();
            }
            if (!isRetained) continue;
            filtratedSNPs.add(snp);
        }
        sampleVariant.renewSNPsInVariant(filtratedSNPs);
        return sampleVariant;
    }

    @Override
    SampleParameter filtrateSampleParameter(SampleParameter sampleParameter) {
        SampleVariant sampleVariant = sampleParameter.getSampleVariant();
        sampleVariant = this.filtrateSampleVariant(sampleVariant);
        sampleParameter.setSampleVariant(sampleVariant);
        return sampleParameter;
    }
}

