/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.artificial;

import edu.zju.common.LineHandler;
import edu.zju.genome.artificial.ArtificialSNP;
import edu.zju.genome.artificial.SampleArtificialChromosome;
import java.util.Random;

public class ArtificialReadGenerator {
    private SampleArtificialChromosome sampleArtificialChromosome;
    private String read;

    public ArtificialReadGenerator(SampleArtificialChromosome sampleArtificialChromosome, String read) {
        this.setSampleArtificialChromosome(sampleArtificialChromosome);
        this.setRead(read);
    }

    private void setSampleArtificialChromosome(SampleArtificialChromosome sampleArtificialChromosome1) {
        this.sampleArtificialChromosome = sampleArtificialChromosome1;
    }

    private void setRead(String read) {
        this.read = read;
    }

    public String getNewRead() {
        LineHandler lh = new LineHandler();
        String line = this.getOldRead();
        lh.splitByTab(line);
        try {
            String alleleQuality = lh.linesplit[10].trim();
            if (alleleQuality.equals("*")) {
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        String readName = lh.linesplit[0].substring(5);
        int readStartPosition = Integer.parseInt(lh.linesplit[3]);
        int readLength = lh.linesplit[9].length();
        char[] cigar = lh.linesplit[5].toCharArray();
        if (lh.linesplit[5].contains("X") || lh.linesplit[5].contains("=")) {
            cigar = this.changeCIGAR(cigar);
            lh.linesplit[5] = new String(cigar);
        }
        SampleArtificialChromosome chromosomeTemp = this.getSampleArtificialChromosome();
        int changeTimes = 0;
        for (ArtificialSNP artificialSNP : chromosomeTemp.getArtificialSNPs()) {
            int artificialSNPPositionInRead = artificialSNP.getPostion() - readStartPosition;
            String genotype = artificialSNP.getGenotype();
            if (artificialSNPPositionInRead < 0 || artificialSNPPositionInRead >= readLength) continue;
            StringBuffer tempStringBuffer = new StringBuffer();
            int descriptionTotalLength = 0;
            for (int i = 0; i < cigar.length; ++i) {
                int descriptionLength;
                if (cigar[i] <= '9' && cigar[i] >= '0') {
                    tempStringBuffer.append(cigar[i]);
                    continue;
                }
                try {
                    descriptionLength = Integer.parseInt(tempStringBuffer.toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                tempStringBuffer = new StringBuffer();
                char operator = cigar[i];
                switch (operator) {
                    case 'M': {
                        break;
                    }
                    case 'I': {
                        if (descriptionTotalLength - 1 >= artificialSNPPositionInRead) break;
                        artificialSNPPositionInRead += descriptionLength;
                        break;
                    }
                    case 'D': {
                        if (artificialSNPPositionInRead >= descriptionTotalLength - 1 && artificialSNPPositionInRead < descriptionTotalLength + descriptionLength - 1) {
                            artificialSNPPositionInRead = 1000;
                            break;
                        }
                        if (artificialSNPPositionInRead <= descriptionTotalLength + descriptionLength - 1) break;
                        artificialSNPPositionInRead -= descriptionLength;
                        descriptionLength = 0;
                    }
                }
                descriptionTotalLength += descriptionLength;
            }
            if (artificialSNPPositionInRead > readLength - 1) continue;
            if (genotype.equals("0/1") && !this.isChangeRead()) {
                ++changeTimes;
                continue;
            }
            StringBuffer temp = new StringBuffer();
            char[] charTemp = lh.linesplit[9].toCharArray();
            for (int i = 0; i < charTemp.length; ++i) {
                if (i == artificialSNPPositionInRead) {
                    temp.append(this.getArtificialMutationalAllele(charTemp[i]));
                    continue;
                }
                temp.append(charTemp[i]);
            }
            lh.linesplit[9] = temp.toString();
            ++changeTimes;
        }
        if (changeTimes == 0) {
            return null;
        }
        StringBuffer tempStringBuffer = new StringBuffer();
        for (int i = 0; i < lh.linesplit.length; ++i) {
            tempStringBuffer.append(lh.linesplit[i] + '\t');
        }
        line = tempStringBuffer.toString();
        line = line.substring(0, line.length() - 1);
        return line;
    }

    private String getOldRead() {
        return this.read;
    }

    private char[] changeCIGAR(char[] cigar) {
        StringBuffer tempStringBuffer = new StringBuffer();
        cigar = new String(cigar).replace('=', 'M').replace('X', 'M').toCharArray();
        StringBuffer newCIGAR = new StringBuffer();
        int descriptionOperatorMLength = 0;
        block3: for (int i = 0; i < cigar.length; ++i) {
            if (cigar[i] <= '9' && cigar[i] >= '0') {
                tempStringBuffer.append(cigar[i]);
                continue;
            }
            if (tempStringBuffer.length() == 0) continue;
            int descriptionLength = Integer.parseInt(tempStringBuffer.toString());
            tempStringBuffer = new StringBuffer();
            char operator = cigar[i];
            switch (operator) {
                case 'M': {
                    descriptionOperatorMLength += descriptionLength;
                    continue block3;
                }
                default: {
                    if (descriptionOperatorMLength != 0) {
                        newCIGAR.append(String.valueOf(descriptionOperatorMLength) + 'M');
                        descriptionOperatorMLength = 0;
                    }
                    newCIGAR.append(String.valueOf(descriptionLength) + operator);
                }
            }
        }
        if (descriptionOperatorMLength != 0) {
            newCIGAR.append(String.valueOf(descriptionOperatorMLength) + "M");
        }
        return newCIGAR.toString().toCharArray();
    }

    private SampleArtificialChromosome getSampleArtificialChromosome() {
        return this.sampleArtificialChromosome;
    }

    private char getArtificialMutationalAllele(char allele) {
        switch (allele) {
            case 'A': {
                return 'T';
            }
            case 'G': {
                return 'C';
            }
            case 'T': {
                return 'A';
            }
            case 'C': {
                return 'G';
            }
        }
        return 'A';
    }

    private boolean isChangeRead() {
        Random r = new Random();
        int s = r.nextInt(2);
        if (s == 0) {
            return true;
        }
        if (s == 1) {
            return false;
        }
        return false;
    }
}

