/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.effectiveRegion;

import edu.zju.genome.effectiveRegion.GeneEffectiveRegion;
import edu.zju.genome.effectiveRegion.PositionContainer;
import edu.zju.genome.gffGenome.Chromosome;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class ChromosomeEffectiveRegion
extends edu.zju.genome.abstractGenome.Chromosome {
    private LinkedList<int[]> effectiveRegionsInChromosome = new LinkedList();
    private HashMap<String, GeneEffectiveRegion> geneEffectiveRegions = new HashMap();
    private HashMap<String, String> geneName2GeneID = new HashMap();
    private int effectiveRegionLength = 0;
    private int maxPosition;

    public ChromosomeEffectiveRegion(Chromosome chromosome) {
        super(chromosome);
        this.setChromosome(chromosome);
    }

    private void setChromosome(Chromosome chromosome) {
        this.setEffectiveRegionsLegth(0);
        String geneID2 = null;
        for (String geneID2 : chromosome.getGeneIDs()) {
            GeneEffectiveRegion geneEffectiveRegion = new GeneEffectiveRegion(chromosome.getGene(geneID2));
            this.addGeneEffectiveRegion(geneEffectiveRegion);
        }
        this.updateEffectiveRegions();
        this.countLength();
    }

    private void addGeneEffectiveRegion(GeneEffectiveRegion geneEffectiveRegion) {
        this.geneEffectiveRegions.put(geneEffectiveRegion.getID(), geneEffectiveRegion);
        this.geneName2GeneID.put(geneEffectiveRegion.getGeneName(), geneEffectiveRegion.getID());
    }

    private void updateEffectiveRegions() {
        PositionContainer positionContainer = new PositionContainer();
        Iterator<String> it = this.geneEffectiveRegions.keySet().iterator();
        while (it.hasNext()) {
            positionContainer.add2Container(this.geneEffectiveRegions.get(it.next()).getEffectiveRegionsInGene());
        }
        this.setRegions(positionContainer.converterPointPosition2Region());
        this.setMaxPosition(this.getRegionsInChromosome().getLast()[1]);
        positionContainer.cleanContainer();
    }

    private void setMaxPosition(int position) {
        this.maxPosition = position;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    private void setRegions(LinkedList<int[]> regions) {
        this.effectiveRegionsInChromosome = regions;
    }

    private void countLength() {
        int length = 0;
        for (int[] region : this.getRegionsInChromosome()) {
            length = length + region[1] - region[0] + 1;
        }
        this.setEffectiveRegionsLegth(length);
    }

    public int getLength() {
        return this.effectiveRegionLength;
    }

    public LinkedList<int[]> getRegionsInChromosome() {
        return this.effectiveRegionsInChromosome;
    }

    public HashSet<Integer> getEffectiveRegionPositionsInChr() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int[] region : this.effectiveRegionsInChromosome) {
            for (int i = region[0]; i <= region[1]; ++i) {
                set.add(i);
            }
        }
        return set;
    }

    private void setEffectiveRegionsLegth(int length) {
        this.effectiveRegionLength = length;
    }

    public boolean isInEffectiveRegion(int position) {
        Iterator iterator = this.getRegionsInChromosome().iterator();
        while (iterator.hasNext()) {
            int[] region = new int[2];
            region = (int[])iterator.next();
            if (position < region[0] || position > region[1]) continue;
            return true;
        }
        return false;
    }

    protected HashMap<String, GeneEffectiveRegion> getGeneEffectiveRegions() {
        return this.geneEffectiveRegions;
    }

    protected LinkedList<GeneEffectiveRegion> getChrGeneEffectiveRegions() {
        LinkedList<GeneEffectiveRegion> list = new LinkedList<GeneEffectiveRegion>(this.geneEffectiveRegions.values());
        Collections.sort(list, new Comparator<GeneEffectiveRegion>(){

            @Override
            public int compare(GeneEffectiveRegion o1, GeneEffectiveRegion o2) {
                return o1.getID().compareTo(o2.getID());
            }
        });
        return list;
    }

    protected HashMap<String, Integer> getGeneEffectiveRegionLengthInChromosome() {
        HashMap<String, Integer> lengthes = new HashMap<String, Integer>();
        for (String geneName : this.getGenesID()) {
            lengthes.put(geneName, this.get1GeneEffectiveRegionByGeneID(geneName).getEffectiveRegionLength());
        }
        return lengthes;
    }

    public Set<String> getGenesID() {
        return this.geneEffectiveRegions.keySet();
    }

    public GeneEffectiveRegion get1GeneEffectiveRegionByGeneID(String geneID) {
        if (this.getGenesID().contains(geneID.trim())) {
            return this.geneEffectiveRegions.get(geneID.trim());
        }
        return null;
    }

    public GeneEffectiveRegion get1GeneEffectiveRegionByGeneName(String geneName) {
        String geneID = this.geneName2GeneID.get(geneName);
        if (geneID == null) {
            return null;
        }
        return this.get1GeneEffectiveRegionByGeneID(geneID);
    }
}

