/*
 * Decompiled with CFR 0.152.
 */
package edu.zju.genome.effectiveRegion;

import edu.zju.genome.effectiveRegion.GenomeEffectiveRegion;
import edu.zju.genome.effectiveRegion.PositionContainer;
import edu.zju.genome.gffGenome.Gene;
import edu.zju.genome.gffGenome.Module;
import edu.zju.genome.gffGenome.Transcript;
import edu.zju.parameter.EffectiveRegionParameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class GeneEffectiveRegion
extends edu.zju.genome.abstractGenome.Gene {
    private HashMap<String, LinkedList<int[]>> effectiveRegionsInGene;
    private int effectiveRegionLength;
    private EffectiveRegionParameter regionParameter;

    public GeneEffectiveRegion(Gene gene) {
        super(gene);
        this.setRegionParameter(GenomeEffectiveRegion.getEffectiveRegionParameter());
        this.effectiveRegionsInGene = new HashMap();
        this.setGeneEffectiveRegion(gene);
    }

    private void setEffectiveRegionsInGene(LinkedList<int[]> effectiveRegions, String type) {
        this.effectiveRegionsInGene.put(type, effectiveRegions);
    }

    private void countLength() {
        PositionContainer positionContainer = new PositionContainer();
        positionContainer.add2Container(this.getEffectiveRegionsInGene());
        this.effectiveRegionLength = positionContainer.getNoRepeatPositionLength();
        positionContainer.cleanContainer();
    }

    public int getEffectiveRegionLength() {
        return this.effectiveRegionLength;
    }

    private void setGeneEffectiveRegion(Gene gene) {
        PositionContainer positionContainer = new PositionContainer();
        if (this.regionParameter.isConsider5UTR()) {
            positionContainer = new PositionContainer();
            positionContainer.add2Container(gene.get1ModuleRegions("five_prime_UTR"));
            this.setEffectiveRegionsInGene(positionContainer.converterPointPosition2Region(), "5UTR");
        }
        if (this.regionParameter.isConsider3UTR()) {
            positionContainer = new PositionContainer();
            positionContainer.add2Container(gene.get1ModuleRegions("three_prime_UTR"));
            this.setEffectiveRegionsInGene(positionContainer.converterPointPosition2Region(), "3UTR");
        }
        if (this.regionParameter.isConsiderCDS()) {
            positionContainer = new PositionContainer();
            positionContainer.add2Container(gene.get1ModuleRegions("CDS"));
            this.setEffectiveRegionsInGene(positionContainer.converterPointPosition2Region(), "CDS");
        }
        if (this.regionParameter.isConsiderExon()) {
            positionContainer = new PositionContainer();
            positionContainer.add2Container(gene.get1ModuleRegions("exon"));
            this.setEffectiveRegionsInGene(positionContainer.converterPointPosition2Region(), "Exon");
        }
        if (this.regionParameter.getPromoterLength() != 0) {
            positionContainer = new PositionContainer();
            positionContainer.add2Container(this.getPromoterRegions(this.regionParameter.getPromoterLength(), gene));
            this.setEffectiveRegionsInGene(positionContainer.converterPointPosition2Region(), "Promoter");
        }
        if (this.regionParameter.getSpliceSite() != 0) {
            positionContainer = new PositionContainer();
            positionContainer.add2Container(this.getSpliceSite(this.regionParameter.getSpliceSite(), gene));
            this.setEffectiveRegionsInGene(positionContainer.converterPointPosition2Region(), "SpliceSite");
        }
        positionContainer.cleanContainer();
        this.countLength();
    }

    private LinkedList<int[]> getPromoterRegions(int length, Gene gene) {
        LinkedList<int[]> regions = new LinkedList<int[]>();
        LinkedList<int[]> five_prime_utr_region = gene.get1ModuleRegions("five_prime_UTR");
        if (five_prime_utr_region.size() == 0) {
            five_prime_utr_region = gene.get1ModuleRegions("transcript");
        }
        for (int[] region : five_prime_utr_region) {
            int start;
            if (gene.getStrand().equals("-")) {
                start = region[1];
                region[0] = start + 1;
                region[1] = start + length;
            } else {
                start = region[0];
                region[0] = start - length;
                region[1] = start - 1;
            }
            regions.add(region);
        }
        return regions;
    }

    private LinkedList<int[]> getSpliceSite(int length, Gene gene) {
        LinkedList<int[]> regions = new LinkedList<int[]>();
        for (Transcript transcript : gene.getTranscripts()) {
            if (transcript.get1Module("exon").size() <= 1) continue;
            int number = 1;
            int[] former = new int[2];
            int[] latter = new int[2];
            for (Module exon : transcript.get1Module("exon")) {
                int[] spliceSite = new int[2];
                if (number == 1) {
                    former = exon.getSite();
                    ++number;
                    continue;
                }
                spliceSite[0] = former[1] + 1;
                spliceSite[1] = former[1] + length;
                regions.add(spliceSite);
                spliceSite = new int[2];
                latter = exon.getSite();
                spliceSite[0] = latter[0] - length;
                spliceSite[1] = latter[0] - 1;
                regions.add(spliceSite);
                former = latter;
            }
        }
        return regions;
    }

    public LinkedList<int[]> getEffectiveRegionsInGene() {
        LinkedList<int[]> list = new LinkedList<int[]>();
        for (String temp : this.effectiveRegionsInGene.keySet()) {
            list.addAll((Collection<int[]>)this.effectiveRegionsInGene.get(temp));
        }
        return list;
    }

    private void setRegionParameter(EffectiveRegionParameter regionParameter) {
        this.regionParameter = regionParameter;
    }

    public boolean isInGeneEffectiveRegion(int pos) {
        for (int[] region : this.getEffectiveRegionsInGene()) {
            if (pos < region[0] || pos > region[1]) continue;
            return true;
        }
        return false;
    }

    public LinkedList<int[]> get1ModelRegion(String type) {
        return this.effectiveRegionsInGene.get(type);
    }
}

